/*
 * PAGES.H
 * Modifications for Chapter 5
 *
 * Definitions and function prototypes for the Pages window control.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _PAGES_H_
#define _PAGES_H_

//Versioning.
#define VERSIONMAJOR                2
#define VERSIONMINOR                0
#define VERSIONCURRENT              0x00020000

//Classname
#define SZCLASSPAGES                "pages"

#define HIMETRIC_PER_INCH           2540
#define LOMETRIC_PER_INCH           254
#define LOMETRIC_BORDER             60          //Border around page


//Window extra bytes and offsets
#define CBPAGESWNDEXTRA             (sizeof(LONG))
#define PAGEWL_STRUCTURE            0




/*
 * Page class describing an individual page and what things it contains,
 * managing an IStorage for us.
 *
 * A DWORD is used to identify this page as the name of the storage
 * is the string form of this ID.  If we added a page every second,
 * it would take 136 years to overrun this counter, so we can
 * get away with saving it persistently.  I hope this software is
 * obsolete by then.
 */

class __far CPage
    {
    private:
        DWORD       m_dwID;             //Persistent DWORD identifier
        //CHAPTER5MOD
        LPSTORAGE   m_pIStorage;        //Sub-storage for this page.
        //End CHAPTER5MOD

    public:
        CPage(DWORD);
        ~CPage(void);

        DWORD   GetID(void);
        //CHAPTER5MOD
        BOOL    FOpen(LPSTORAGE);
        void    Close(BOOL);
        void    Update(void);
        void    Destroy(LPSTORAGE);
        //End CHAPTER5MOD
    };

typedef CPage FAR * LPPAGE;



//CHAPTER5MOD

/*
 * Structures to save with the document describing the device
 * configuration and pages that we have.  This is followed by
 * a list of DWORD IDs for the individual pages.
 */

typedef struct __far tagDEVICECONFIG
    {
    DEVMODE     dm;
    char        szDriver[CCHDEVICENAME];
    char        szDevice[CCHDEVICENAME];
    char        szPort[CCHDEVICENAME];
    } DEVICECONFIG, FAR * LPDEVICECONFIG;

typedef struct __far tagPAGELIST
    {
    UINT        cPages;
    UINT        iPageCur;
    DWORD       dwIDNext;
    } PAGELIST, FAR *LPPAGELIST;

//End CHAPTER5MOD


//PAGEWIN.CPP
LRESULT __export FAR PASCAL PagesWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL    __export FAR PASCAL AbortProc(HDC, int);
BOOL    __export FAR PASCAL PrintDlgProc(HWND, UINT, WPARAM, LPARAM);



class __far CPages : public CWindow
    {
    friend LRESULT __export FAR PASCAL PagesWndProc(HWND, UINT, WPARAM, LPARAM);
    friend BOOL    __export FAR PASCAL PrintDlgProc(HWND, UINT, WPARAM, LPARAM);

    private:
        UINT        m_iPageCur;             //Current page we're viewing
        UINT        m_cPages;               //Number of pages

        HWND        m_hWndPageList;         //Listbox that manages out page list
        HFONT       m_hFont;                //Page font.
        BOOL        m_fSystemFont;          //Is m_hFont system object?

        UINT        m_cx;                   //Current page size in LOMETRIC
        UINT        m_cy;

        UINT        m_xMarginLeft;          //Unusable page margins, LOMETRIC
        UINT        m_xMarginRight;
        UINT        m_yMarginTop;
        UINT        m_yMarginBottom;

        UINT        m_xPos;                 //Current viewport scroll position.
        UINT        m_yPos;                 //both in *PIXELS*

        DWORD       m_dwIDNext;             //Next ID for a page.

        //CHAPTER5MOD
        LPSTORAGE   m_pIStorage;            //Root storage of document.

        //m_hDevMode, m_szDriver, m_szDevice, m_szPort removed
        //End CHAPTER5MOD

    private:
        void      Draw(HDC, BOOL, BOOL);
        void      UpdateScrollRanges(void);
        void      RectConvertMappings(LPRECT, HDC, BOOL);
        BOOL      ConfigureForDevice(void);
        BOOL      FPageGet(UINT, LPPAGE FAR *, BOOL);
        BOOL      FPageAdd(UINT, DWORD, BOOL);

    public:
        CPages(HINSTANCE);
        ~CPages(void);

        BOOL      FInit(HWND, LPRECT, DWORD, UINT, LPVOID);

        //CHAPTER5MOD
        BOOL      FIStorageSet(LPSTORAGE, BOOL, BOOL); //Was ::New previously
        BOOL      FIStorageUpdate(BOOL);
        //End CHAPTER5MOD

        BOOL      Print(HDC, LPSTR, DWORD, UINT, UINT, UINT);

        void      RectGet(LPRECT);
        void      RectSet(LPRECT, BOOL);
        void      SizeGet(LPRECT);
        void      SizeSet(LPRECT, BOOL);

        UINT      PageInsert(UINT);
        UINT      PageDelete(UINT);
        UINT      CurPageGet(void);
        UINT      CurPageSet(UINT);
        UINT      NumPagesGet(void);

        BOOL      DevModeSet(HGLOBAL, HGLOBAL);
        HGLOBAL   DevModeGet(void);
    };

typedef CPages FAR * LPCPages;


//CHAPTER5MOD
//Fixed names of streams in the Pages IStorage
#define SZSTREAMPAGELIST        "Page List"
#define SZSTREAMDEVICECONFIG    "Device Configuration"
//End CHAPTER5MOD


#endif  //_PAGES_H_
