/*
 * FREELOAD.H
 *
 * Class overrides for the FreeLoader application
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _FREELOAD_H_
#define _FREELOAD_H_

#include <windows.h>
#include <ole2.h>
#include <ole2ver.h>
#include <bookguid.h>

//Stolen from OLEGUID.H
DEFINE_OLEGUID(CLSID_StaticMetafile,        0x00000315, 0, 0);
DEFINE_OLEGUID(CLSID_StaticDib,             0x00000316, 0, 0);


//These include files reference DLLs that don't have extern "C" already
extern "C"
    {
    #include <commdlg.h>
    }

#include <classlib.h>



//FREELOAD.CPP:  Frame object that creates a main window

class __far CFreeloaderFrame : public CFrame
    {
    private:
        BOOL            m_fInitialized;     //OleInitialize work?

    protected:
        //Overridable for creating a CClient for this frame
        virtual LPCClient CreateCClient(void);

    public:
        CFreeloaderFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CFreeloaderFrame(void);

        virtual BOOL FInit(LPFRAMEINIT);
    };


typedef CFreeloaderFrame FAR * LPCFreeloaderFrame;





//CLIENT.CPP

//Override to create CFreeloaderDoc
class __far CFreeloaderClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CFreeloaderClient(HINSTANCE);
        virtual ~CFreeloaderClient(void);
    };


typedef CFreeloaderClient FAR * LPCFreeloaderClient;




//DOCUMENT.CPP

//Override file and clipboard operations as well as painting.
class __far CFreeloaderDoc : public CDocument
    {
    protected:
        LPSTORAGE           m_pIStorage;        //Root storage for this doc
        LPUNKNOWN           m_pIUnknown;        //Static visual object.
        DWORD               m_dwConn;           //From IOleCache::Cache

    protected:
        //Centralized cleanup
        void ReleaseObject(void);

        //To catch WM_PAINT
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);

    public:
        CFreeloaderDoc(HINSTANCE);
        virtual ~CFreeloaderDoc(void);

        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);

        virtual BOOL     FClip(HWND, BOOL);
        virtual HGLOBAL  RenderFormat(UINT);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(HWND);
    };

typedef CFreeloaderDoc FAR * LPCFreeloaderDoc;


#endif //_FREELOAD_H_
