/*
 * RESOURCE.H
 * Modifications for Chapter 7
 *
 * Definitions specifically pertaining to resources.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */



#ifndef _RESOURCE_H_
#define _RESOURCE_H_

//Note that we augment classlib.h which we include before this.


//Position of Window menu.
#undef  WINDOW_MENU
#define WINDOW_MENU                 3


//Total number of menus
#undef  CMENUS
#define CMENUS                      4


//Menu command identifiers.

#define IDM_FILEPRINT               (IDM_CUSTOMFILEMIN)
#define IDM_FILEPRINTERSETUP        (IDM_CUSTOMFILEMIN+1)

//CHAPTER7MOD
#define IDM_EDITPASTESPECIAL        (IDM_CUSTOMEDITMIN)
#define IDM_EDITDELETEOBJECT        (IDM_CUSTOMEDITMIN+1)
//End CHAPTER7MOD

#define IDM_PAGENEWPAGE             (IDM_CUSTOMMIN)
#define IDM_PAGEDELETEPAGE          (IDM_CUSTOMMIN+1)
#define IDM_PAGENEXTPAGE            (IDM_CUSTOMMIN+2)
#define IDM_PAGEPREVIOUSPAGE        (IDM_CUSTOMMIN+3)
#define IDM_PAGEFIRSTPAGE           (IDM_CUSTOMMIN+4)
#define IDM_PAGELASTPAGE            (IDM_CUSTOMMIN+5)



/*
 * IDs for StatStrip handling of popup menus:  must be in order of menu
 * CLASSRES.H already defines ID_MENUFILE and ID_MENUEDIT for us.
 */

#undef ID_MENUWINDOW
#undef ID_MENUHELP

#define ID_MENUPAGE                 (ID_STANDARDMAX+3)
#define ID_MENUWINDOW               (ID_STANDARDMAX+4)
#define ID_MENUHELP                 (ID_STANDARDMAX+5)


//Stringtable IDs.  Keep sequential for each group.
#define IDS_FRAMEMIN                IDS_STANDARDFRAMEMIN
#define IDS_FRAMEMAX                IDS_STANDARDFRAMEMAX

#define IDS_DOCUMENTMIN             IDS_STANDARDDOCMIN
#define IDS_PRINTERROR              (IDS_STANDARDDOCMAX+1)
#define IDS_DOCUMENTNAME            (IDS_STANDARDDOCMAX+2)

//CHAPTER7MOD
#define IDS_PASTEASPATRON           (IDS_STANDARDDOCMAX+3)
#define IDS_PASTEMETAFILE           (IDS_STANDARDDOCMAX+4)
#define IDS_PASTEASMETAFILE         (IDS_STANDARDDOCMAX+5)
#define IDS_PASTEDIB                (IDS_STANDARDDOCMAX+6)
#define IDS_PASTEASDIB              (IDS_STANDARDDOCMAX+7)
#define IDS_PASTEBITMAP             (IDS_STANDARDDOCMAX+8)
#define IDS_PASTEASBITMAP           (IDS_STANDARDDOCMAX+9)
#define IDS_DOCUMENTMAX             (IDS_STANDARDDOCMAX+9)
//End CHAPTER7MOD


//These are specifically for the StatStrip
#define IDS_STATMESSAGEMIN                  IDS_STANDARDSTATMESSAGEMIN

#define IDS_ITEMMESSAGEFILEPRINT            (IDS_STANDARDSTATMESSAGEMAX+1)
#define IDS_ITEMMESSAGEFILEPRINTERSETUP     (IDS_STANDARDSTATMESSAGEMAX+2)

#define IDS_MENUMESSAGEPAGE                 (IDS_STANDARDSTATMESSAGEMAX+3)
#define IDS_ITEMMESSAGEPAGENEWPAGE          (IDS_STANDARDSTATMESSAGEMAX+4)
#define IDS_ITEMMESSAGEPAGEDELETEPAGE       (IDS_STANDARDSTATMESSAGEMAX+5)
#define IDS_ITEMMESSAGEPAGENEXTPAGE         (IDS_STANDARDSTATMESSAGEMAX+6)
#define IDS_ITEMMESSAGEPAGEPREVIOUSPAGE     (IDS_STANDARDSTATMESSAGEMAX+7)
#define IDS_ITEMMESSAGEPAGEFIRSTPAGE        (IDS_STANDARDSTATMESSAGEMAX+8)
#define IDS_ITEMMESSAGEPAGELASTPAGE         (IDS_STANDARDSTATMESSAGEMAX+9)

//CHAPTER7MOD
#define IDS_ITEMMESSAGEEDITPASTESPECIAL     (IDS_STANDARDSTATMESSAGEMAX+10)
#define IDS_ITEMMESSAGEEDITDELETEOBJECT     (IDS_STANDARDSTATMESSAGEMAX+11)
#define IDS_STATMESSAGEMAX                  (IDS_STANDARDSTATMESSAGEMAX+12)
//End CHAPTER7MOD


//Definitions for the printing dialog.

#define IDD_PRINTING                2

#define ID_CURRENTPAGE              101
#define ID_CURRENTCOPY              102
#define ID_COPYSTRING               103
#define ID_PAGESTRING               104

#define PRINTM_PAGEUPDATE           (WM_USER+100)
#define PRINTM_COPYUPDATE           (WM_USER+101)

#endif //_RESOURCE_H_
