/*
 * PATRON.H
 * Modifications for Chapter 8
 *
 * Single include file that pulls in everything needed for other source
 * files in the application.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _PATRON_H_
#define _PATRON_H_

#include <windows.h>

#include <ole2.h>
#include <ole2ver.h>
#include <ole2ui.h>
#include <bookguid.h>

extern "C"
    {
    #include <commdlg.h>
    #include <print.h>
    }

#include <classlib.h>
#include "resource.h"

//Get editor window information
#include "pages.h"

//PATRON.CPP:  Frame object that creates a main window

class __far CPatronFrame : public CFrame
    {
    private:
        BOOL            m_fInitialized;     //OleInitialize worked

    protected:
        //Overridable for creating a CPatronClient
        virtual LPCClient CreateCClient(void);

        virtual BOOL      FRegisterAllClasses(void);
        virtual UINT      CreateGizmos(void);
        virtual LRESULT   OnCommand(HWND, WPARAM, LPARAM);

    public:
        CPatronFrame(HINSTANCE, HINSTANCE, LPSTR, int);
        virtual ~CPatronFrame(void);

        //Overrides
        BOOL FInit(LPFRAMEINIT);

        virtual void     UpdateMenus(HMENU, UINT);
        virtual void     UpdateGizmos(void);

    };


typedef CPatronFrame FAR * LPCPatronFrame;





//CLIENT.CPP

/*
 * The only reason we have a derived class here is to override
 * CreateCDocument so we can create our own type as well as
 * overriding NewDocument to perform one other piece of work once the
 * document's been created.
 */

class __far CPatronClient : public CClient
    {
    protected:
        //Overridable for creating a new CDocument
        virtual LPCDocument CreateCDocument();

    public:
        CPatronClient(HINSTANCE);
        virtual ~CPatronClient(void);
    };

typedef CPatronClient FAR * LPCPatronClient;



//DOCUMENT.CPP

//Constant ID for the pages window that lives in a document window
#define ID_PAGES            723


class __far CPatronDoc : public CDocument
    {
    //CHAPTER8MOD
    //These need access to FQueryPasteFromData, FPasteFromData
    friend class CDropTarget;
    friend class CDropSource;
    //End CHAPTER8MOD

    protected:
        LONG            m_lVer;         //Loaded data version
        LPCPages        m_pPG;          //Pages window in us.
        LPSTORAGE       m_pIStorage;    //Root storage for document.
        BOOL            m_fPrintSetup;  //Enable printer setup if no tenants.

        //CHAPTER8MOD
        class CDropTarget FAR *m_pDropTarget;  //Registered target.
        //End CHAPTER8MOD

    protected:
        virtual BOOL    FMessageHook(HWND, UINT, WPARAM, LPARAM, LRESULT FAR *);

        BOOL            FQueryPasteFromData(LPDATAOBJECT, LPFORMATETC, LPTENANTTYPE);
        BOOL            FPasteFromData(LPDATAOBJECT, LPFORMATETC, TENANTTYPE
                            , LPPATRONOBJECT, DWORD);

    public:
        CPatronDoc(HINSTANCE);
        virtual ~CPatronDoc(void);

        virtual BOOL     FInit(LPDOCUMENTINIT);
        virtual void     Clear(void);

        virtual BOOL     FDirtyGet(void);
        virtual void     Delete(void);
        virtual BOOL     FQueryPrinterSetup(void);
        virtual BOOL     FQueryObjectSelected(void);

        virtual UINT     ULoad(BOOL, LPSTR);
        virtual UINT     USave(UINT, LPSTR);

        virtual BOOL     Print(HWND);
        virtual UINT     PrinterSetup(HWND, BOOL);

        virtual BOOL     FClip(HWND, BOOL);
        virtual BOOL     FQueryPaste(void);
        virtual BOOL     FPaste(HWND);
        virtual BOOL     FPasteSpecial(HWND);

        virtual UINT     NewPage(void);
        virtual UINT     DeletePage(void);
        virtual UINT     NextPage(void);
        virtual UINT     PreviousPage(void);
        virtual UINT     FirstPage(void);
        virtual UINT     LastPage(void);
    };

typedef CPatronDoc FAR * LPCPatronDoc;


//CHAPTER8MOD
//Drag-drop interfaces we need in the document

class __far CDropTarget : public IDropTarget
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPCPatronDoc        m_pDoc;      //Back pointer to the document

        LPDATAOBJECT        m_pIDataObject;  //Data object from DragEnter
        BOOL                m_fPendingRepaint;
        POINTL              m_ptPick;        //Pick-up offsets
        POINTL              m_ptLast;        //Last drag point
        SIZEL               m_szl;           //Object size
        BOOL                m_fFeedback;     //Draw feedback?
        FORMATETC           m_fe;            //Real dropping format.

    public:
        CDropTarget(LPCPatronDoc);
        ~CDropTarget(void);

        //IDropTarget interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP DragEnter(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragOver(DWORD, POINTL, LPDWORD);
        STDMETHODIMP DragLeave(void);
        STDMETHODIMP Drop(LPDATAOBJECT, DWORD, POINTL, LPDWORD);
    };


typedef CDropTarget FAR * LPCDropTarget;

class __far CDropSource : public IDropSource
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.

    public:
        CDropSource(void);
        ~CDropSource(void);

        //IDropSource interface members
        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP QueryContinueDrag(BOOL, DWORD);
        STDMETHODIMP GiveFeedback(DWORD);
    };


typedef CDropSource FAR * LPCDropSource;

//End CHAPTER8MOD


#endif //_PATRON_H_
