/*
 * DEBUG.H
 *
 * Definitions, structures, types, and function prototypes for debugging
 * purposes.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  INTERNET>kraigb@microsoft.com

 */

#ifndef _DEBUG_H
#define _DEBUG_H

#ifdef DEBUG

//Basic debug macros
#define D(x)              {x;}
#define ODS(x)            D(OutputDebugString(x);OutputDebugString("\r\n"))

#define ODSsz(f, s)       {\
                          char szDebug[128];\
                          wsprintf(szDebug, f, (LPSTR)s);\
                          ODS(szDebug);\
                          }


#define ODSu(f, u)        {\
                          char szDebug[128];\
                          wsprintf(szDebug, f, (UINT)u);\
                          ODS(szDebug);\
                          }


#define ODSlu(f, lu)      {\
                          char szDebug[128];\
                          wsprintf(szDebug, f, (DWORD)lu);\
                          ODS(szDebug);\
                          }

#define ODSlulu(f, l1,l2) {\
                          char szDebug[128];\
                          wsprintf(szDebug, f, (DWORD)l1, (DWORD)l2);\
                          ODS(szDebug);\
                          }

#define ODSszu(f, s, u)   {\
                          char szDebug[128];\
                          wsprintf(szDebug, f, (LPSTR)s, (UINT)u);\
                          ODS(szDebug);\
                          }


#define ODSszlu(f, s, lu) {\
                          char szDebug[128];\
                          wsprintf(szDebug, f, (LPSTR)s, (DWORD)lu);\
                          ODS(szDebug);\
                          }


#else   //!DEBUG

#define D(x)
#define ODS(x)

#define ODSsz(f, s)
#define ODSu(f, u)
#define ODSlu(f, lu)
#define ODSlulu(f, l1,l2)
#define ODSszu(f, s, u)
#define ODSszlu(f, s, lu)


#endif //!DEBUG

#endif //_DEBUG_H
