/*
 * IENUM.H
 * RECTEnumerator Object version 1.00
 *
 * Public definition of an IEnumRECT interface that can be used from
 * a DLL-based component object.  Since at the time of this writing
 * parameter marshalling for arbitrary interfaces across a process
 * boundary is not fully documented, the limitation is for DLLs.
 *
 * This include file works for C or C++ applications that are using
 * the DLLENUM.DLL component.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _IENUM_H_
#define _IENUM_H_



/*
 * These class id values are allocated out exclusively for use
 * by the author.  To get IDs that you can ship in a product,
 * send a letter to the OLE 2.0 Coordinator care of Microsoft,
 * send a fax to the same at (206)93MSFAX, or request them
 * through the OLE 2.0 forum on Compuserve (WINEXT section 17)
 *     00021100-0000-0000-C000-000000000046
 *     000211FF-0000-0000-C000-000000000046
 */

DEFINE_OLEGUID(CLSID_RECTEnumerator, 0x00021100, 0, 0);
DEFINE_OLEGUID(IID_IEnumRECT,        0x00021101, 0, 0);



//We use the OLE 2.0 macro to define a new interface
#undef  INTERFACE
#define INTERFACE IEnumRECT


DECLARE_INTERFACE_(IEnumRECT, IUnknown)
    {
    //IUnknown members
    STDMETHOD(QueryInterface) (THIS_ REFIID, LPVOID FAR *) PURE;
    STDMETHOD_(ULONG,AddRef)  (THIS) PURE;
    STDMETHOD_(ULONG,Release) (THIS) PURE;

    //IEnumRECTmembers
    STDMETHOD(Next)  (THIS_ ULONG, LPRECT, ULONG FAR *) PURE;
    STDMETHOD(Skip)  (THIS_ ULONG) PURE;
    STDMETHOD(Reset) (THIS) PURE;
    STDMETHOD(Clone) (THIS_ IEnumRECT FAR * FAR *) PURE;
    };


typedef IEnumRECT FAR * LPENUMRECT;


#endif //_IENUM_H_
