/*
 * IPERFILE.CPP
 *
 * Template implementation of an IPersistFile interface.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#include "iperstor.h"


/*
 * CImpIPersistFile:CImpIPersistFile
 * CImpIPersistFile::~CImpIPersistFile
 *
 * Constructor Parameters:
 *  pObj            LPVOID pointing to the object we live in.
 *  punkOuter       LPUNKNOWN of the controlling unknown.
 */

CImpIPersistFile::CImpIPersistFile(LPVOID pObj, LPUNKNOWN punkOuter)
    {
    m_cRef=0;
    m_pObj=pObj;
    m_punkOuter=punkOuter;
    return;
    }


CImpIPersistFile::~CImpIPersistFile(void)
    {
    return;
    }




/*
 * CImpIPersistFile::QueryInterface
 * CImpIPersistFile::AddRef
 * CImpIPersistFile::Release
 *
 * Purpose:
 *  Standard set of IUnknown members for this interface
 */

STDMETHODIMP CImpIPersistFile::QueryInterface(REFIID riid, LPVOID FAR *ppv)
    {
    return m_punkOuter->QueryInterface(riid, ppv);
    }

STDMETHODIMP_(ULONG) CImpIPersistFile::AddRef(void)
    {
    ++m_cRef;
    return m_punkOuter->AddRef();
    }

STDMETHODIMP_(ULONG) CImpIPersistFile::Release(void)
    {
    --m_cRef;
    return m_punkOuter->Release();
    }





/*
 * CImpIPersistFile::GetClassID
 *
 * Purpose:
 *  Returns the CLSID of the object represented by this interface.
 *
 * Parameters:
 *  pClsID          LPCLSID in which to store our CLSID.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIPersistFile::GetClassID(LPCLSID pClsID)
    {
    return NOERROR;
    }





/*
 * CImpIPersistFile::IsDirty
 *
 * Purpose:
 *  Tells the caller if we have made changes to this object since
 *  it was loaded or initialized new.
 *
 * Parameters:
 *  None
 *
 * Return Value:
 *  HRESULT         Contains S_OK if we ARE dirty, S_FALSE if NOT dirty,
 *                  that is, "Yes I AM dirty, or NO, I'm clean."
 */

STDMETHODIMP CImpIPersistFile::IsDirty(void)
    {
    return ResultFromScode(S_FALSE);
    }








/*
 * CImpIPersistFile::Load
 *
 * Purpose:
 *  Instructs the object to load itself from a previously saved file
 *  that was handled by ::Save in another object lifetime.
 *
 * Parameters:
 *  pszFile         LPSTR of the filename to load.
 *  grfMode         DWORD flags to use when opening the file.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIPersistFile::Load(LPSTR pszFile, DWORD grfMode)
    {
    return NOERROR;
    }





/*
 * CImpIPersistFile::Save
 *
 * Purpose:
 *  Saves the native data for this object to file and alternately
 *  remember this file as the current file.  After this has been
 *  called and before a call to ::SaveCompleted we are not allowed
 *  to scribble into the file.
 *
 * Parameters:
 *  pszFile         LPSTR of the filename in which to save.
 *  fRemember       BOOL indicating if we should use this file as
 *                  the current file, in captions and internal structures.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIPersistFile::Save(LPSTR pszFile, BOOL fRemember)
    {
    return NOERROR;
    }








/*
 * CImpIPersistFile::SaveCompleted
 *
 * Purpose:
 *  Notifies the object that the file in pszFile has been completely
 *  saved, allowing the object to write to that file again.
 *
 * Parameters:
 *  pszFile         LPSTR of the file in which we can start writing again.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIPersistFile::SaveCompleted(LPSTR pszFile)
    {
    return NOERROR;
    }





/*
 * CImpIPersistFile::GetCurFile
 *
 * Purpose:
 *  Returns the current filename in use by this object.
 *
 * Parameters:
 *  ppszFile        LPSTR FAR * into which we save the pointer.
 *
 * Return Value:
 *  HRESULT         NOERROR on success, error code otherwise.
 */

STDMETHODIMP CImpIPersistFile::GetCurFile(LPSTR FAR *ppszFile)
    {
    return NOERROR;
    }
