/*
 * IPERFILE.H
 *
 * Definitions of a template IPersistFile interface implementation.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _IPERFILE_H_
#define _IPERFILE_H_


class __far CImpIPersistFile : public IPersistFile
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPVOID              m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistFile(LPVOID, LPUNKNOWN);
        ~CImpIPersistFile(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP Load(LPSTR);
        STDMETHODIMP Save(LPSTR, BOOL);
        STDMETHODIMP SaveCompleted(LPSTR);
        STDMETHODIMP GetCurFile(LPSTR FAR *);
    };

typedef CImpIPersistFile * LPCIMPIPERSISTFILE;


#endif  //_IPERFILE_H_
