/*
 * IPERSTRM.H
 *
 * Definitions of a template IPersistStream interface implementation.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 * Kraig Brockschmidt, Software Design Engineer
 * Microsoft Systems Developer Relations
 *
 * Internet  :  kraigb@microsoft.com
 * Compuserve:  >INTERNET:kraigb@microsoft.com
 */


#ifndef _IPERSTOR_H_
#define _IPERSTOR_H_


class __far CImpIPersistStream : public IPersistStream
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPVOID              m_pObj;      //Back pointer to the object.
        LPUNKNOWN           m_punkOuter; //Controlling unknown for delegation.

    public:
        CImpIPersistStream(LPVOID, LPUNKNOWN);
        ~CImpIPersistStream(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        STDMETHODIMP GetClassID(LPCLSID);

        STDMETHODIMP IsDirty(void);
        STDMETHODIMP Load(LPSTREAM);
        STDMETHODIMP Save(LPSTREAM, BOOL);
        STDMETHODIMP GetSizeMax(ULARGE_INTEGER FAR *);
    };

typedef CImpIPersistStream * LPCIMPIPERSISTSTORAGE;




#endif  //_IPERSTOR_H_
