/*
 * BOOKGUID.H
 *
 * CLSIDs and IIDs defined for the Windows Object book.  This file
 * centralizes them all so we can keep track of which ones are used.
 * The file also includes a number of useful macros that all samples
 * might be interested in as well as including DEBUG.H and WIN1632.H.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 */


//#ifndef _BOOKGUID_H_
#define _BOOKGUID_H_


#include <win1632.h>
#include <debug.h>

#ifdef INITGUIDS
#include <initguid.h>
#endif


//Useful macros.
#define SETFormatEtc(fe, cf, asp, td, med, li)   \
    {\
    (fe).cfFormat=cf;\
    (fe).dwAspect=asp;\
    (fe).ptd=td;\
    (fe).tymed=med;\
    (fe).lindex=li;\
    };

#define SETDefFormatEtc(fe, cf, med)   \
    {\
    (fe).cfFormat=cf;\
    (fe).dwAspect=DVASPECT_CONTENT;\
    (fe).ptd=NULL;\
    (fe).tymed=med;\
    (fe).lindex=-1;\
    };


#define SETRECTL(rcl, l, t, r, b) \
    {\
    (rcl).left=l;\
    (rcl).top=t;\
    (rcl).right=r;\
    (rcl).bottom=b;\
    }

#define SETSIZEL(szl, h, v) \
    {\
    (szl).cx=h;\
    (szl).cy=v;\
    }


#define RECTLFROMRECT(rcl, rc)\
    {\
    (rcl).left=(long)(rc).left;\
    (rcl).top=(long)(rc).top;\
    (rcl).right=(long)(rc).right;\
    (rcl).bottom=(long)(rc).bottom;\
    }


#define RECTFROMRECTL(rc, rcl)\
    {\
    (rc).left=(int)(rcl).left;\
    (rc).top=(int)(rcl).top;\
    (rc).right=(int)(rcl).right;\
    (rc).bottom=(int)(rcl).bottom;\
    }





/*
 * GUIDs
 *
 * For this sample I allocated the GUIDs in the range:
 *     77777770-0000-0000-C000-000000000046
 *     77777775-0000-0000-C000-000000000046
 */


DEFINE_OLEGUID(CLSID_DataObjectSymbol,     0x77777770, 0, 0);
DEFINE_OLEGUID(IID_IClassFactory,         0x77777774, 0, 0);
DEFINE_OLEGUID(IID_IUnknown,              0x77777774, 0, 0);
