/*
 * DATAUSER.CPP
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 */


#define INITGUIDS
#include "olecont.h"
#include <math.h>
#include <stdlib.h>


/*
 * WinMain
 *
 * Purpose:
 *  Main entry point of application.
 *
 * Parameters:
 *  Standard
 *
 * Return Value:
 *  Value to return to Windows--termination code.
 */

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hInstPrev
    , LPSTR pszCmdLine, int nCmdShow)
    {
    MSG         msg;
    LPAPPVARS   pAV;

    //Create and initialize the application.
    pAV=new CAppVars(hInst, hInstPrev, nCmdShow);

    if (NULL==pAV)
        return -1;

    if (pAV->FInit())
        {
        while (GetMessage(&msg, NULL, 0,0 ))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    delete pAV;
    return msg.wParam;
    }







/*
 * DataUserWndProc
 *
 * Purpose:
 *  Window class procedure.  Standard callback.
 *
 * Parameters:
 *  Standard
 *
 * Return Value:
 *  Standard
 */

LRESULT FAR PASCAL __export DataUserWndProc(HWND hWnd, UINT iMsg
    , WPARAM wParam, LPARAM lParam)
    {
    HRESULT         hr;
    LPAPPVARS       pAV;
    HMENU           hMenu;
    FORMATETC       fe;
    WORD            wID;

    //This will be valid for all messages except WM_NCCREATE
    pAV=(LPAPPVARS)GetWindowLong(hWnd, DATAUSERWL_STRUCTURE);

    switch (iMsg)
        {
        case WM_NCCREATE:
            //CreateWindow passed pAV to us.
            pAV=(LPAPPVARS)((LONG)((LPCREATESTRUCT)lParam)->lpCreateParams);
            SetWindowLong(hWnd, DATAUSERWL_STRUCTURE, (LONG)pAV);
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_PAINT:
            pAV->Paint();
            break;

        case WM_COMMAND:
            hMenu=GetMenu(hWnd);
            wID=LOWORD(wParam);

            switch (wID)
                {
                case IDM_OBJECTGETDATA:
                    if (NULL==pAV->m_pIDataObject)
                        break;

                    //Clean up whatever we currently have.
                    SETDefFormatEtc(fe, CF_TEXT, TYMED_HGLOBAL);
                    
                    pAV->m_stm.tymed=fe.tymed;
                    hr=pAV->m_pIDataObject->GetData(&fe, &(pAV->m_stm));

                    if(pAV->m_dwConn)
                    {
                        pAV->m_pIDataObject->DUnadvise(pAV->m_dwConn);
                    }
        
                    pAV->m_pIDataObject->DAdvise(&fe, ADVF_NODATA, pAV->m_pIAdviseSink, 
                    &pAV->m_dwConn);

                    if (SUCCEEDED(hr))
                        pAV->m_cf=fe.cfFormat;

                    InvalidateRect(hWnd, NULL, TRUE);
                    UpdateWindow(hWnd);
                    break;

                case IDM_OBJECTEXIT:
                    PostMessage(hWnd, WM_CLOSE, 0, 0L);
                    break;

                default:
                    break;
                }
            break;

        default:
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));
        }

    return 0L;
    }





/*
 * CAppVars::CAppVars
 * CAppVars::~CAppVars
 *
 * Constructor Parameters: (from WinMain)
 *  hInst           HINSTANCE of the application.
 *  hInstPrev       HINSTANCE of a previous instance.
 *  nCmdShow        UINT specifying how to show the app window.
 *
 */

CAppVars::CAppVars(HINSTANCE hInst, HINSTANCE hInstPrev, UINT nCmdShow)
    {
    m_hInst       =hInst;
    m_hInstPrev   =hInstPrev;
    m_nCmdShow    =nCmdShow;

    m_hWnd        =NULL;

    m_pIAdviseSink =NULL;
    m_dwConn       =0;
    m_cfAdvise     =CF_TEXT;

    m_pIDataObject =NULL;

    m_cf=0;
    m_stm.tymed=TYMED_NULL;
    m_stm.lpszFileName=NULL;      //Initializes union contents to NULL.
    m_stm.pUnkForRelease=NULL;

    m_fInitialized=FALSE;
    return;
    }


CAppVars::~CAppVars(void)
    {
    //This releases the data object interfaces and advises
    FReloadDataObjects(FALSE);

    ReleaseStgMedium(&m_stm);

    if (NULL!=m_pIAdviseSink)
        m_pIAdviseSink->Release();

    if (IsWindow(m_hWnd))
        DestroyWindow(m_hWnd);

    if (m_fInitialized)
        CoUninitialize();

    return;
    }







/*
 * CAppVars::FInit
 *
 * Purpose:
 *  Initializes an CAppVars object by registering window classes,
 *  creating the main window, and doing anything else prone to failure
 *  such as calling CoInitialize.  If this function fails the caller
 *  should insure that the destructor is called.
 *
 * Parameters:
 *  None
 *
 * Return Value:
 *  BOOL            TRUE if successful, FALSE otherwise.
 */

BOOL CAppVars::FInit(void)
    {
    WNDCLASS    wc;
    DWORD       dwVer;
    BOOL        fRet;

    dwVer=CoBuildVersion();

    if (rmm!=HIWORD(dwVer))
        return FALSE;

    if (FAILED(CoInitialize(NULL)))
        return FALSE;

    m_fInitialized=TRUE;

    //Register our window classes.
    if (!m_hInstPrev)
        {
        wc.style          = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc    = DataUserWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = CBWNDEXTRA;
        wc.hInstance      = m_hInst;
        wc.hIcon          = LoadIcon(m_hInst, "Icon");
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
        wc.lpszMenuName   = MAKEINTRESOURCE(IDR_MENU);
        wc.lpszClassName  = "DATAUSER";

        if (!RegisterClass(&wc))
            return FALSE;
        }

    //Create the main window.
    m_hWnd=CreateWindow("DATAUSER", "OLE Container"
        , WS_OVERLAPPEDWINDOW,35, 35, 350, 250, NULL, NULL, m_hInst, this);

    if (NULL==m_hWnd)
        return FALSE;

    //Paint window
    ShowWindow(m_hWnd, m_nCmdShow);
    UpdateWindow(m_hWnd);

    //Instantiate the container's IAdviseSink class    
    m_pIAdviseSink=new CImpIAdviseSink(this);

    if (NULL==m_pIAdviseSink)
        return FALSE;

    //Increment the reference count on IAdviseSink class    
    m_pIAdviseSink->AddRef();

    //Load the initial data object
    fRet=FReloadDataObjects(TRUE);

    return fRet;
    }





/*
 * CAppVars::FReloadDataObjects
 *
 * Purpose:
 *  Releases the old data objects we're holding on to and reloads
 *  the new ones from either EXE or DLL depending on m_fEXE.
 *
 * Parameters:
 *  fReload         BOOL indicating if we are to recreate everything
 *                  or just release the old ones (so we can use this
 *                  from the destructor).
 *
 * Return Value:
 *  BOOL            TRUE if there are usable objects in us now.
 */

BOOL CAppVars::FReloadDataObjects(BOOL fReload)
    {
    HRESULT     hr1;
    HCURSOR     hCur, hCurT;
    LPCLASSFACTORY  pIClassFactory;

    //Clean out any data we're holding
    m_cf=0;
    ReleaseStgMedium(&m_stm);

    //Turn off whatever data connection we have
    if (NULL!=m_pIDataObject && 0!=m_dwConn)
        m_pIDataObject->DUnadvise(m_dwConn);

    if (NULL!=m_pIDataObject)
        m_pIDataObject->Release();

    m_pIDataObject=NULL;
    CoFreeUnusedLibraries();

    //Exit if we just wanted to free.
    if (!fReload)
        return FALSE;

    hCur=LoadCursor(NULL, MAKEINTRESOURCE(IDC_WAIT));
    hCurT=SetCursor(hCur);
    ShowCursor(TRUE);

/**********************************************************************
* Normally, an OLE 2.0 container would get the path of the OLE object *
* from the registration database. To ease setup, I load it directly.  *
**********************************************************************/

//    CoLoadLibrary("c:\\wosaxrt\\svrdll\\ddataobj.dll",FALSE);    

/*********************************************************************
** Helper function, CoCreateInstance, can also be used here.        **
*********************************************************************/

    hr1=CoGetClassObject(CLSID_DataObjectSymbol, CLSCTX_INPROC_SERVER, NULL
        , IID_IClassFactory, (LPVOID FAR *)&pIClassFactory);

    if (SUCCEEDED(hr1))
        {
        pIClassFactory->CreateInstance(NULL
            , IID_IDataObject, (LPVOID FAR *)&m_pIDataObject);

        //We're done with the class factory, so release it.
        pIClassFactory->Release();
    }

    ShowCursor(FALSE);
    SetCursor(hCurT);

    //If anything fails, recurse to clean up...
    if (FAILED(hr1))
        return FReloadDataObjects(FALSE);

    return TRUE;
    }



/*
 * CAppVars::Paint
 *
 * Purpose:
 *  Handles WM_PAINT for the main window by drawing whatever data we
 *  have sitting in the STGMEDIUM at this time.
 *
 * Parameters:
 *  None
 *
 * Return Value:
 *  None
 */

void CAppVars::Paint(void)
    {
    PAINTSTRUCT     ps;
    HDC             hDC;
    LPMARKETDATA    lpMD;
    char szAsk[10],szAskSize[10],szBid[10],szBidSize[10],szVolume[10],szTime[10], buf[50];

    hDC=BeginPaint(m_hWnd, &ps);

    wsprintf(buf,"%s\t%s\t%s\t%s\t%s\t%s\t%s", (LPSTR) "Symbol", (LPSTR) "Ask", (LPSTR) "Ask Size",
        (LPSTR) "Bid", (LPSTR) "Bid Size", (LPSTR) "Volume", (LPSTR) "Time");

    TabbedTextOut(hDC, 1, 1, buf, lstrlen(buf), NULL, NULL, NULL);


    switch (m_cf)
        {
        case CF_TEXT:
            lpMD=(LPMARKETDATA)GlobalLock(m_stm.hGlobal);

            if (NULL==lpMD)
                break;

            SetTextColor(hDC, GetSysColor(COLOR_WINDOWTEXT));
            SetBkColor(hDC, GetSysColor(COLOR_WINDOW));

        FractionToString(lpMD->ask,(LPSTR) szAsk);
        wsprintf(szAskSize,"%li",(long)lpMD->asksize);
        FractionToString(lpMD->bid,(LPSTR) szBid);
        wsprintf(szBidSize,"%li",(long)lpMD->bidsize);
        wsprintf(szVolume,"%li",(long)lpMD->volume);
        wsprintf(szTime,"%i:%i:%i",12,0,0);
            
        wsprintf(buf,"%s\t%s\t%s\t%s\t%s\t%s\t%s", (LPSTR) lpMD->symbol, (LPSTR) szAsk, (LPSTR) szAskSize,
        (LPSTR) szBid, (LPSTR) szBidSize, (LPSTR) szVolume, (LPSTR) szTime);

            TabbedTextOut(hDC, 1, 20, buf, lstrlen(buf), NULL, NULL, NULL);
            GlobalUnlock(m_stm.hGlobal);
            break;


        default:
            break;
        }

    EndPaint(m_hWnd, &ps);
    return;
    }



/*
 * Fraction To String
 *
 * Purpose:
 *  Extracts price from a unsigned long where the HIWORD is the integer value
 *  and the LOWORD is the numerator of the fraction portion of the price
 *  with the denominator being 256. The function will reduce the fraction if
 *  necessary. The price is returned as a string.
 *            
 * Parameters:
 *  price in unsigned long format, storage to place the string
 *
 * Return Value:
 *  1 after completion
 */

int FractionToString(DWORD data, LPSTR buf){
    int number, numer, denom, a;
    
// Get integer
    number = LOWORD(data); 

// Get fraction    
    numer = HIWORD(data);
    denom = 256;

// Try to reduce fraction
    for(a = 128;a >= 2;a -= (a/2)){
        if(numer % a == 0){
            numer = (int)(numer / a);
            denom = (int)(256 / a);
            break;
        }    
    }     
        
    wsprintf(buf,"%d %d/%d",number,numer,denom);    
    return 1;    
}

/*
 * StringToFraction
 *
 * Purpose:
 *  Takes a price in string format and returns it in long format.
 *            
 * Parameters:
 *  storage containing the string
 *
 * Return Value:
 *  price in unsigned long format 
 */

DWORD StringToFraction(LPSTR buf){
    LPSTR lpBuf = buf;
    int number, numer, denom,i;
    char sznumber[10],sznumer[10],szdenom[10];
    
    if (buf == 0) return 0L;
    
//Extract integer portion of price
    i=0;
    while(*lpBuf != ' '){
        sznumber[i++] = *lpBuf++;
    }
     
    lpBuf ++;
     
//Extract numerator portion of price
    i=0;
    while(*lpBuf != '/'){
        sznumer[i++] = *lpBuf++;
    }
    
    lpBuf ++;
     
//Extract denomintor portion of price
    i=0;
    while(*lpBuf != 0){
        szdenom[i++] = *lpBuf++;
    }           

//Change strings to integers    
    number = atoi(sznumber);
    numer = atoi(sznumer);
    denom = atoi(szdenom);
    
//Induce fraction to n/256
    numer = numer * (256 / denom);
    
    return MAKELONG(number,numer);
}

