/*
 * DATAUSER.H
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 */


#ifndef _DATAUSER_H_
#define _DATAUSER_H_

#include <windows.h>
#include <ole2.h>
#include <ole2ver.h>
#include "mybookid.h"


//Menu Resource ID and Commands
#define IDR_MENU                    1

#define IDM_OBJECTGETDATA		0x101
#define IDM_OBJECTEXIT			0x102

//DATAUSER.CPP
LRESULT FAR PASCAL __export DataUserWndProc(HWND, UINT, WPARAM, LPARAM);

typedef struct tagMARKETDATA{
	char	symbol[40];
	DWORD	ask;
	DWORD	asksize;
	DWORD	bid;
	DWORD bidsize;
	DWORD volume;
	DWORD time;
}MARKETDATA;  

typedef MARKETDATA FAR * LPMARKETDATA;

class __far CImpIAdviseSink;


/*
 * Application-defined classes and types.
 */

class __far CAppVars
    {
    friend LRESULT FAR PASCAL __export DataUserWndProc(HWND, UINT, WPARAM, LPARAM);
    friend class CImpIAdviseSink;

    protected:
        HINSTANCE       m_hInst;            //WinMain parameters
        HINSTANCE       m_hInstPrev;		  
        UINT            m_nCmdShow;

        HWND            m_hWnd;             //Main window handle

        LPADVISESINK    m_pIAdviseSink;     //Our CImpIAdviseSink
        DWORD           m_dwConn;           //Advise connection
        UINT            m_cfAdvise;         //Advise format

        LPDATAOBJECT    m_pIDataObject;     //Current selection
        UINT            m_cf;
        STGMEDIUM       m_stm;              //Current rendering we obtained

        BOOL            m_fInitialized;     //Did CoInitialize work?

    public:
        CAppVars(HINSTANCE, HINSTANCE, UINT);
        ~CAppVars(void);
        BOOL FInit(void);
        BOOL FReloadDataObjects(BOOL);
        void TryQueryGetData(LPFORMATETC, UINT, BOOL, UINT);
        void Paint(void);
    };


typedef CAppVars FAR * LPAPPVARS;


#define CBWNDEXTRA              sizeof(LONG)
#define DATAUSERWL_STRUCTURE     0


//This lives with the application to get OnDataChange notifications.

class __far CImpIAdviseSink : public IAdviseSink
    {
    protected:
        ULONG               m_cRef;      //Interface reference count.
        LPAPPVARS           m_pAV;       //Back pointer to the application

    public:
        CImpIAdviseSink(LPAPPVARS);
        ~CImpIAdviseSink(void);

        STDMETHODIMP QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //We only implement OnDataChange for now.
        STDMETHODIMP_(void)  OnDataChange(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP_(void)  OnViewChange(DWORD, LONG);
        STDMETHODIMP_(void)  OnRename(LPMONIKER);
        STDMETHODIMP_(void)  OnSave(void);
        STDMETHODIMP_(void)  OnClose(void);
    };


typedef CImpIAdviseSink FAR * LPIMPIADVISESINK;


#endif //_DATAUSER_H_

DWORD StringToFraction(LPSTR buf);
int FractionToString(DWORD data, LPSTR buf);

#define NODATAADVISEHOLDER		  4

