/*
 * DATAOBJ.H
 *
 * Classes that implement the Data Object independent of whether
 * we live in a DLL or EXE.
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 */

#ifndef _DATAOBJ_H_
#define _DATAOBJ_H_

#include <windows.h>
#include <ole2.h>
#include "mybookid.h"

//Type for an object-destroyed callback
typedef void (FAR PASCAL *LPFNDESTROYED)(void);

//defualt menu
#define IDR_MENU                        1

//default icon
#define IDR_ADVISORICON                 1

/*NOTE: NODATAADVISEHOLDER is used only with this sample and should not be used 
with any other implementation of OLE 2.0 interfaces. */
 
#define NODATAADVISEHOLDER		  4
#define DOSIZE_SYMBOL		 	  0

/*
 * The DataObject object is implemented in its own class with its own
 * IUnknown to support aggregation.  It contains one CImpIDataObject
 * object that we use to implement the externally exposed interfaces.
 */


//DATAOBJ.CPP
LRESULT FAR PASCAL __export AdvisorWndProc(HWND, UINT, WPARAM, LPARAM);


class __far CDataObject : public IUnknown
    {
    //Make any contained interfaces your friends so they can get at you
    friend class CImpIDataObject;
    friend LRESULT FAR PASCAL __export AdvisorWndProc(HWND, UINT, WPARAM, LPARAM);

    protected:
        ULONG               m_cRef;         //Object reference count.
        LPUNKNOWN           m_punkOuter;    //Cont. Unk. for aggregation
        LPFNDESTROYED       m_pfnDestroy;   //Function to call on closure.

        UINT                m_iSize;        //Data size for ::Render*

        HWND                m_hWndAdvise;   //Popup with Advise menu
        DWORD               m_dwAdvFlags;   //Notification flags.

        //Contained interface implemetation
        LPDATAOBJECT        m_pIDataObject;

        //Other interfaces used, implemented elsewhere
        LPDATAADVISEHOLDER  m_pIDataAdviseHolder;
		  LPADVISESINK 		 m_pIAdviseSink;

		  //Use IDataAdviseHolder Or Not
		  BOOL					 m_UseDataAdviseHolder;

		  //Keeps MARKETDATA allocated throughout life of object	
		  STGMEDIUM				 m_stg;		
    protected:
        //Functions for use from IDataObject::GetData
        HRESULT     RenderSymbol(LPSTGMEDIUM);

    public:
        CDataObject(LPUNKNOWN, LPFNDESTROYED, UINT);
        ~CDataObject(void);

        BOOL FInit(void);

        //Non-delegating object IUnknown
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);
    };

typedef CDataObject FAR * LPCDataObject;



/*
 * Interface implementations for the CDataObject object.
 */

class __far CImpIDataObject : public IDataObject
    {
    private:
        ULONG           m_cRef;         //Interface reference count.
        LPVOID          m_pObj;         //Back pointer to the object.
        LPUNKNOWN       m_punkOuter;    //Controlling unknown for delegation

    public:
        CImpIDataObject(LPVOID, LPUNKNOWN);
        ~CImpIDataObject(void);

        //IUnknown members that delegate to m_punkOuter.
        STDMETHODIMP         QueryInterface(REFIID, LPVOID FAR *);
        STDMETHODIMP_(ULONG) AddRef(void);
        STDMETHODIMP_(ULONG) Release(void);

        //IDataObject members
        STDMETHODIMP GetData(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP GetDataHere(LPFORMATETC, LPSTGMEDIUM);
        STDMETHODIMP QueryGetData(LPFORMATETC);
        STDMETHODIMP GetCanonicalFormatEtc(LPFORMATETC, LPFORMATETC);
        STDMETHODIMP SetData(LPFORMATETC, STGMEDIUM FAR *, BOOL);
        STDMETHODIMP EnumFormatEtc(DWORD, LPENUMFORMATETC FAR *);
        STDMETHODIMP DAdvise(FORMATETC FAR *, DWORD,  LPADVISESINK, DWORD FAR *);
        STDMETHODIMP DUnadvise(DWORD);
        STDMETHODIMP EnumDAdvise(LPENUMSTATDATA FAR *);
    };

typedef struct tagMARKETDATA{
	char	symbol[40];
	DWORD	ask;
	DWORD	asksize;
	DWORD	bid;
	DWORD bidsize;
	DWORD volume;
	DWORD time;
}MARKETDATA;  

typedef MARKETDATA FAR * LPMARKETDATA;

#define IDM_ADVISEMIN	 	100
#define IDM_ADVISE1SEC	 	101
#define IDM_ADVISE2SEC		102
#define IDM_ADVISE4SEC		104
#define IDM_ADVISE10SEC		110
#define IDM_ADVISE30SEC		130
#define IDM_ADVISE60SEC		160
#define IDM_USEDATAADVISEHOLDER		170	 

#endif //_DATAOBJ_H_
