/*
 * RENDER.CPP
 *
 * CDataObject::Render function to fill a MARKETDATA struct
 *
 * Copyright (c)1993 Microsoft Corporation, All Rights Reserved
 *
 */


#include "dataobj.h"
#include <string.h>
#include <stdlib.h>



/*
 * CDataObject::RenderSymbol
 *
 * Purpose:
 *  Creates a global memory block containing the letter 'k' of sizes
 *  of 64 bytes, 1024 bytes, and 16384 bytes, into a caller-supplied
 *  STGMEDIUM.
 *
 * Parameters:
 *  pSTM            LPSTGMEDIUM in which to render.
 *
 * Return Value:
 *  HRESULT         Return value for ::GetData
 */

HRESULT CDataObject::RenderSymbol(LPSTGMEDIUM pSTM)
    {
    LPMARKETDATA    lpMD;

    if (m_stg.hGlobal==NULL)
    {
        return ResultFromScode(STG_E_INVALIDHANDLE);
    }

    lpMD = (LPMARKETDATA) GlobalLock(m_stg.hGlobal);

    lstrcpy(lpMD->symbol, "MSFT.0");
    lpMD->ask = (DWORD) MAKELONG(88,200);
    lpMD->asksize = 600;
    lpMD->bid = (DWORD) MAKELONG(86,64);
    lpMD->bidsize = 750;
    lpMD->volume = 712098;

    GlobalUnlock(m_stg.hGlobal);

    pSTM->hGlobal=m_stg.hGlobal;
    pSTM->tymed=TYMED_HGLOBAL;

    return NOERROR;
    }



