#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <sys/file.h>
#include <errno.h>

extern int	errno;
extern char	*rindex();
char		*Progname;

main(argc, argv)
int	argc;
char	**argv;
{
	char			buf[1024];
	unsigned long		l;
	struct sockaddr_in	sin;
	struct hostent		*hp;
	struct servent		*sp;
	extern int		optind;
	extern char		*optarg;
	int			c, v, n, i;
	int			s;
	extern int		optind;
	FILE			*in;
	char			*cp;
#ifdef WHOIS
	char			*service = "whois", *host = "nic.ddn.mil";
#else
	char			*service = "finger", *host = "localhost";
#endif

	if ((Progname = rindex(argv[0], '/')) == NULL)
		Progname = argv[0];
	else
		Progname++;

#ifdef WHOIS
	while ((i = getopt(argc,argv,"h:")) != EOF) {
		switch (i) {
		case 'h':
			host = optarg;
			break;
		default:
			fprintf(stderr,"Usage: %s [-h host] name\n", Progname);
			exit(1);
		}
	}
#endif

	buf[0] = '\0';
	for (i = optind; i < argc; i++) 
		strcat(buf, argv[i]);
	
#ifndef WHOIS
	if ((cp = rindex(buf, '@')) != NULL) {
		*cp = '\0';
		host = cp + 1;
	} else {
		execvp("finger", argv);
		fprintf(stderr, "Unable to run finger\n");
		exit(1);
	}
#endif

	sin.sin_family = AF_INET;

	SOCKSinit();

	if ((sp = getservbyname(service, "tcp")) == NULL) {
		if ((v = atoi(service)) == 0) {
			fprintf(stderr, "%s: unknown service '%s'\n",
				Progname, service);
			exit(1);
		}
		sin.sin_port = htons((short) v);
	} else {
		sin.sin_port = htons(sp->s_port);
	}

	if ((hp = gethostbyname(host)) == NULL) {
		if ((l = inet_addr(host)) == -1) {
			fprintf(stderr, "%s: unknown host '%s'\n",
				Progname, host);
			exit(1);
		}
		sin.sin_addr.s_addr = htonl(l);
	} else {
		bcopy(*hp->h_addr_list, &sin.sin_addr, hp->h_length);
		hp->h_addr_list++;
	}

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		fprintf(stderr, "%s: ", Progname);
		perror("socket");
		exit(1);
	}

	while (Rconnect(s, &sin, sizeof(sin)) < 0) {
		if ((errno == ETIMEDOUT) && (hp != NULL) && 
		    (hp->h_addr != NULL)) {
			bcopy(*hp->h_addr_list, &sin.sin_addr, hp->h_length);
			hp->h_addr_list++;
			continue;
		}
		fprintf(stderr, "%s: ", Progname);
		perror("connect");
		exit(1);
	}

	strcat(buf, "\r\n");

	if (write(s,buf,strlen(buf)) < 0) {
		fprintf(stderr, "%s: ", Progname);
		perror("write");
	}

	while ((n = read(s, buf, sizeof(buf) - 1)) > 0) {
		write(1, buf, n);
	}

	close(s);
}
