///////////////////////////////////////////////////////////////////////////
//
//  Test LARGE attached sprite, and hardware sprite collision under
// OS 3.0.
//
//  This demo will create a 16 color sprite thats 64 * 64 pixels, 4
// planes. It moves around the sprite, and uses hardware collision 
// detection to keep the sprite within an area of the screen until you
// change views, or click the mouse. 
// See the Rom Kernal Manuals (Hardware and Intuition) for more
// information on sprites.
//
//  NOTE:  This hack is just for example... I just made it to test sprites
// under V39. There is some error checking, but it's not complete. Also,
// it peeks some hardware addresses (to check for mouse) and this is bad
// practice on the Amiga!
//          Also, it only compiles under SAS 6.0 or greater! Sorry, but
// thats what I use, and some of the features (like auto opening of Amiga
// libraries) save me time when doing R&D! If you want to change this,
// add code to open all needed libraries (and close them), and get rid
// of the stubs below!
//
// Troy Barlow
// CIS #: 75416,3364
//
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <exec/types.h>
#include <hardware/custom.h>
#include <graphics/gfxbase.h>
#include <graphics/gels.h>
#include <graphics/videocontrol.h>
#include <proto/graphics.h>
#include <proto/exec.h>

#include "testsprite.h"

extern struct Custom __far custom;

// STUBS to disable SAS CTRL/C
int CXBRK(void) { return 0; }
int chkabort(void) { return 0; }

// Stub thats called if OpeLibrary fails
void __autoopenfail(char *lib)
{
  _XCEXIT(9);
}

long __OSlibversion = 39L;  // Use 3.0 only!


#define WIDTH  320                 
#define HEIGHT 200  
#define DEPTH    8 

#define SPRITE_W 64
#define SPRITE_H 64

#define SPEED 2   // Number of pixels to move each sprite

struct View my_view;
struct View *my_old_view = NULL;
struct ViewPort my_view_port;
struct ViewPortExtra *myvpe = NULL;
struct RasInfo my_ras_info;
struct RastPort my_rast_port;
struct BitMap *my_bit_map = NULL, sp_bm;
struct ExtSprite *esprite[2] = { NULL, NULL };
WORD spgot[2] = { -1, -1 };
UWORD oldp=0xFFFF;
  
void clean_up( void );
void main();

void main()
{
  WORD x = 44, y = 32, x_direction = SPEED, y_direction = SPEED;
  UWORD uwBits;
    
  atexit( clean_up );
    
  // Boost our priority. Note that you should NOT call intuition when at
  // this priority!  
	oldp=SetTaskPri(FindTask(0),30);

  // Save the current View, so we can restore it later
  my_old_view = GfxBase->ActiView;

  // Setup the View structure 
  InitView( &my_view );
  my_view.ViewPort = &my_view_port;

  // Setup the ViewPort structure
  InitVPort( &my_view_port );
  my_view_port.DWidth = WIDTH;         
  my_view_port.DHeight = HEIGHT;       
  my_view_port.Modes = SPRITES;
  my_view_port.RasInfo = &my_ras_info; 

  // Get a colour map
  my_view_port.ColorMap = (struct ColorMap *) GetColorMap( 256 );
  if( my_view_port.ColorMap == NULL )
  {
    printf("Error getting colormap!\n");
    exit(9);
  }
  
  // Prepare the BitMap
  my_bit_map = AllocBitMap(WIDTH,HEIGHT,DEPTH,BMF_CLEAR|BMF_DISPLAYABLE,
                           NULL );
  if ( !my_bit_map )
  {
    printf("Error getting bitmap!\n");
    exit(9);
  }
  
  // Prepare RasInfo 
  memset( &my_ras_info, 0, sizeof(struct RasInfo) );
  my_ras_info.BitMap = my_bit_map;

  // Allocate viewportextra structure
  myvpe = (struct ViewPortExtra *) GfxNew( VIEWPORT_EXTRA_TYPE );
  if ( !myvpe )
  {
    printf("Cant get vpextra!\n");
    exit(9);
  }

  // Attach viewportextra to our view port
	VideoControlTags(my_view_port.ColorMap,VTAG_VIEWPORTEXTRA_SET,myvpe,TAG_END);
	VideoControlTags(my_view_port.ColorMap,VTAG_ATTACH_CM_SET,
                &my_view_port,TAG_END);

  // Start all odd and even sprite color register bases at 0 
  // (color 0 - 16)
	VideoControlTags(my_view_port.ColorMap,VTAG_SPODD_BASE_SET,0,TAG_END);
	VideoControlTags(my_view_port.ColorMap,VTAG_SPEVEN_BASE_SET,0,TAG_END);

  // Setup bitmap for sprite
  InitBitMap( &sp_bm, 4, SPRITE_W, SPRITE_H );  
  sp_bm.Planes[0] = (UBYTE *)testsprite;
  sp_bm.Planes[1] = (UBYTE *)testsprite1;
  sp_bm.Planes[2] = (UBYTE *)testsprite2;
  sp_bm.Planes[3] = (UBYTE *)testsprite3;

  InitRastPort( &my_rast_port );
  my_rast_port.BitMap = my_bit_map;

  // Create the display
  MakeVPort( &my_view, &my_view_port );

  // Set palette
  SetRGB32(&my_view_port,0,0,0,0);
  SetRGB32(&my_view_port,1,255 << 24,255 << 24,255 << 24 );
  SetRGB32(&my_view_port,2,0,255 << 24, 0 );
  SetRGB32(&my_view_port,3,170 << 24,85 << 24,0 );
  SetRGB32(&my_view_port,4,0,0, 255 << 24 );
  SetRGB32(&my_view_port,5,0,0, 255 << 24 );
  SetRGB32(&my_view_port,6,0,3 << 24,212 << 24 );
  SetRGB32(&my_view_port,7,0,2 << 24, 169 << 24 );
  SetRGB32(&my_view_port,8,255 << 24,255 << 24,0 );
  SetRGB32(&my_view_port,9,255 << 24,252 << 24, 43 << 24 );
  SetRGB32(&my_view_port,10,255 << 24,249 << 24,86 << 24 );
  SetRGB32(&my_view_port,11,255 << 24,250 << 24,128 << 24 );
  SetRGB32(&my_view_port,12,255 << 24,0,0 );
  SetRGB32(&my_view_port,13,255 << 24,42 << 24, 43 << 24 );
  SetRGB32(&my_view_port,14,255 << 24,86 << 24, 86 << 24 );
  SetRGB32(&my_view_port,15,255 << 24,128 << 24,128 << 24 );
  SetRGB32(&my_view_port,16,127 << 24,127 << 24,127 << 24 );

  MakeVPort( &my_view, &my_view_port );

  // Setup copper list
  MrgCop( &my_view );

  // Show the new View
  LoadView( &my_view );

  // Draw a box to keep the sprite within. We will use color 16
  SetAPen( &my_rast_port, 16 );
  Move( &my_rast_port, 20, 20 );
  Draw( &my_rast_port, WIDTH - 20, 20 );
  Draw( &my_rast_port, WIDTH - 20, HEIGHT - 20 );
  Draw( &my_rast_port, 20, HEIGHT - 20 );
  Draw( &my_rast_port, 20, 20 );

  // Allocate and build sprite data for bottom sprite. 
  // cccc cccc ....     = Control line for esprite 0
  // dddd dddd ....     = Data for esprite 0
  // .... ....         
  // cccc cccc ....     = END control line
  esprite[0] = AllocSpriteData( &sp_bm, SPRITEA_Width, (ULONG)SPRITE_W,
                    TAG_END );
  if ( !esprite[0] )
  {
    printf("Cant get sprite data!\n");
    exit(9);
  }

  // Allocate and build sprite data for top attached sprite. 
  esprite[1] = AllocSpriteData( &sp_bm, SPRITEA_Attached, esprite[0], 
                SPRITEA_Width, (ULONG)SPRITE_W, TAG_END );
  if ( !esprite[1] )
  {
    printf("Cant get sprite data!\n");
    exit(9);
  }

  // Grab 2 hardware sprites to use
  if ( -1 == (spgot[0] = GetExtSprite( esprite[0], 
                          GSTAG_SPRITE_NUM, 6L, TAG_END )) )
  {
    printf("Cant get sprite!\n");
    exit(9);
  }

  if ( -1 == (spgot[1] = GetExtSprite( esprite[1], 
                          GSTAG_SPRITE_NUM, 7L, TAG_END )) )
  {
    printf("Cant get sprite!\n");
    exit(9);
  }

  // Attach esprite 1 to esprite 0
  // This should be done with GetExtSprite(), however it don't work
  // under V39.
  esprite[1]->es_SimpleSprite.posctldata[1] = (UWORD)SPRITE_ATTACHED;

  // Draw both sprites just to get them turned on. 
  MoveSprite( NULL, (struct SimpleSprite *)esprite[0], x, y );
  MoveSprite( NULL, (struct SimpleSprite *)esprite[1], x, y );

  // Setup hardware sprite collison detection as follows:
  // Odd sprites disabled (Bits 15 - 12 are zero (bit 15 == SPR 7)
  // Enable bitplanes 6 - 1 (Bits 11 - 6 are one (BIT 11 == bitplane 6)
  // Match values, planes 6 - 1 (Bits 5 - 0 (Bit 5 == bitplane 6) are set
  // to the color value we want to detect (in our case register # 16). I'm
  // not sure how to use bitplanes higher than 6! Any help?
  // Note that this register is WRITE ONLY!
  //  Odd Sprite Enable    BitPlane enable     Match value
  //      0000                 111111            010000  
  custom.clxcon = 0x0FD0U;

  // When you want to check for a collision, the bits are read as follows:
  // 15 - Not Used. Seems to be set all the time! Maybe indicates extended?
  // 14 - Sprite 4 (or 5 if enabled) collided with sprite 6 (or 7)
  // 13 - Sprite 2 (or 3 ) to sprite 6 (or 7)
  // 12 - Sprite 2 (or 3 ) to sprite 4 (or 5)
  // 11 - Sprite 0 (or 1 ) to sprite 6 (or 7)  
  // 10 - Sprite 0 (or 1 ) to sprite 4 (or 5)
  //  9 - Sprite 0 (or 1 ) to sprite 2 (or 3)
  //  8 - Even bitplanes to sprite 6 ( or 7 )
  //  7 - Even bitplanes to sprite 4 ( or 5 )
  //  6 - Even bitplanes to sprite 2 ( or 3 )
  //  5 - Even bitplanes to sprite 0 ( or 1 )
  //  4 - Odd bitplanes to sprite 6 ( or 7 )
  //  3 - Odd bitplanes to sprite 4 ( or 5 )
  //  2 - Odd bitplanes to sprite 2 ( or 3 )
  //  1 - Odd bitplanes to sprite 0 ( or 1 )
  //  0 - Even bitplanes to Odd bitplanes
  //  uwBits = custom.clxdat; // Register is READ ONLY!

  // Wait until the user changes views, or presses the mouse button
	for(;(GfxBase->ActiView==&my_view) && 
       ((*((BYTE *) 0xbfe001) & 192)==192);)
  {
    // Move in the Y direction
    y += y_direction;
    MoveSprite( NULL, (struct SimpleSprite *)esprite[0], x, y );

    // Wait for Top Of Display since thats when the sprite will be in it's
    // new position. This must be done because it seems that custom.clxdat
    // is only set once at the start of the display! Is there any other
    // way to cause custom.clxdat to get set? If you know a better way,
    // PLEASE LET ME KNOW!!!! The problem is that if you move many sprites
    // in many directions during one display, how can you easily detect
    // where the sprites collided? I.E. If sprite 6 collides with color
    // 16, what direction should you change? As you can see, I'm trying
    // to build screens with a single color as a mask... This can be used
    // to keep sprites within a area of the screen.
    WaitTOF();

    // Check for collision. If bit 4 is set (16), sprite 6 collided with
    // a pixel in color 16. Since we only moved in the Y direction, that
    // means we collided with the top, or bottom. Reverse our Y direction!
    uwBits = custom.clxdat;
    if ( uwBits & 0x0010 )
    {
      y_direction = (y_direction == SPEED) ? -SPEED: SPEED;      
      y += y_direction;
    }

    // Move in the X direction
    x += x_direction;
    MoveSprite( NULL, (struct SimpleSprite *)esprite[0], x, y );

    // Wait for sprite to be drawn
    WaitTOF();

    // Check for collision. If bit 4 is set (16), sprite 6 collided with
    // a pixel in color 16. Since we only moved in the X direction, that
    // means we collided with the top, or bottom. Reverse our X direction!
    uwBits = custom.clxdat;
    if ( uwBits & 0x0010 )
    {
      x_direction = (x_direction == SPEED) ? -SPEED: SPEED;      
      x += x_direction;
    }
  }

  exit(0);
}

void clean_up( void )
{
  if ( GfxBase->ActiView == &my_view )
  {
    LoadView( my_old_view );
    WaitTOF();
  }

  if ( -1 != spgot[0] )
    FreeSprite( spgot[0] );

  if ( -1 != spgot[1] )
    FreeSprite( spgot[1] );

  if ( esprite[0] )
    FreeSpriteData( esprite[0] );

  if ( esprite[1] )
    FreeSpriteData( esprite[1] );


  FreeVPortCopLists( &my_view_port );
  
  if ( oldp != 0xFFFF )
    SetTaskPri( FindTask(0), oldp );
  
  if ( my_view.LOFCprList )
    FreeCprList( my_view.LOFCprList );
  
  if ( my_bit_map )
    FreeBitMap( my_bit_map );

  if ( my_view_port.ColorMap ) 
    FreeColorMap( my_view_port.ColorMap );

	if ( myvpe ) 
    GfxFree( myvpe );
}

