#ifndef __E_GEM_LIB__
#define __E_GEM_LIB__

#include <portab.h>
#include <tos.h>
#include <aes.h>
#include <vdi.h>

#define AES_VERSION		_GemParBlk.global[0]

#define WM_UNTOPPED		30
#define WM_ONTOP		31
#define AP_TERM			50
#define AP_RESCHG		57
#define AP_TFAIL		51
#define SHUT_COMPLETED	60
#define RESCH_COMPLETED 61
#define CH_EXIT			80

#define WF_BEVENT		24

#define	HOR_SLIDER		0
#define	VERT_SLIDER		1

#define CENTER			1
#define MOUSEPOS		2
#define XPOS			3
#define YPOS			4
#define XYPOS			5

#define POPUP			0
#define POPUP_CYCLE		1
#define CYCLE			2

#define FLY_DIAL		1
#define WIN_DIAL		2
#define AUTO_DIAL		(FLY_DIAL|WIN_DIAL)
#define MODAL			4
#define FRAME			8

#define CHECKBOX		1
#define HEADER			2
#define RADIO			3
#define UNDERLINE		4
#define HOTKEY			5
#define CHKHOTKEY		6
#define RBHOTKEY		7
#define INDHOTKEY		8
#define FLYDIAL 		9
#define TXTDEFAULT		10
#define USERFLY			11
#define HELP_BTN		12
#define ATTR_TEXT		13
#define CYCLE_BUTTON	14
#define ARROW_LEFT		15
#define ARROW_RIGHT		16
#define ARROW_UP		17
#define ARROW_DOWN		18

#define G_HOTKEY		(0x1000|G_USERDEF)
#define G_IND			(0x2000|G_USERDEF)
#define G_RB			(0x3000|G_USERDEF)
#define G_CHK			(0x4000|G_USERDEF)
#define G_FLY			(0x5000|G_USERDEF)

#define INDDEFAULT		0x8000
#define NULL			( ( void * ) 0L )

#define SL_STEP			0
#define SL_LINEAR		1
#define SL_LOG			2
#define SL_EXP			3

#define W_ABANDON		-1
#define W_CLOSED		-2
#define W_INIT			2

#define NO_SCALING		0
#define SCALING			1
#define TEST_SCALING	2
#define DARK_SCALING	4

#define BOOLEAN			boolean
#define DIALMODE		dialmode

typedef struct
{
	long	cookie;
	long	product;
	int		version;
	int		x,y,w,h;
} INFOVSCR;

typedef struct
{
	long	cookie_id;
	long	cookie_value;
} COOKIE;

typedef enum
{
	FAIL = -1,
    FALSE,
    TRUE
} boolean;

typedef enum
{
	CLOSED,
	OPENED,
	FLYING,
	WINDOW,
	WIN_MODAL
} dialmode;

typedef struct
{
	long		di_mem;
	MFDB		di_mfdb;
	DIALMODE	di_flag;
	long		di_length;
	OBJECT		*di_tree;
	int			di_handle;
	int			di_fly;
	OBJECT		*di_ed_objptr;
	int			di_ed_obj,di_ed_index;
	int			di_default,di_help;
	int			di_xy_off,di_wh_off;
} DIAINFO;

typedef struct
{
	int		v_x1;
	int		v_y1;
	int		v_x2;
	int		v_y2;
} VRECT;

typedef struct
{
	int	dummy;
	int	*image;
} RS_IMDOPE;

typedef struct
{
	int		*hi_on,*hi_off,*lo_on,*lo_off;
} IMAGE;

typedef struct
{
	int		count;
	IMAGE	*image;
} IMAGES;

extern 	int	ap_id, grhandle, x_handle;
extern 	int	gr_cw, gr_ch, gr_bw, gr_bh, gr_sw, gr_sh;
extern 	int	max_w, max_h, planes, aes_version, small_font, ibm_font;
extern	GRECT desk;
extern	VRECT clip;
extern	MFDB  *screen;

int		vq_aes(void);

void	ob_dostate(OBJECT *,int,int);
void	ob_undostate(OBJECT *,int,int);
int		ob_isstate(OBJECT *,int,int);
void	ob_doflag(OBJECT *,int,int);
void	ob_undoflag(OBJECT *,int,int);
int		ob_isflag(OBJECT *,int,int);
void	ob_xywh(OBJECT *,int,GRECT *);
char	*ob_get_text(OBJECT *,int,int);
void	ob_set_text(OBJECT *,int,char *);
void	ob_draw_chg(DIAINFO *,int,GRECT *,int,boolean);
void	ob_draw_dialog(OBJECT *,int,int,int,int);
void	ob_undraw_dialog(OBJECT *,int,int,int,int);
int		ob_radio(OBJECT *,int,int);

int		rc_equal(GRECT *,GRECT *);
void	rc_copy(GRECT *,GRECT *);
int		rc_intersect(GRECT *,GRECT *);
int		rc_inside(int,int,GRECT *);
void	rc_grect_to_array(GRECT *,int *);
void	rc_scr_copy(GRECT *,int,int,int);
void	rc_clear(GRECT *);

void	scrp_clear(void);
int		scrp_init(char *);
int		scrp_length(void);
int		scrp_find(char *,char *);

void	rsrc_calc(OBJECT *,int);
void 	rsrc_init(int,int,int,int,int,char **,long *,BITBLK *,long *,ICONBLK *,TEDINFO *,OBJECT *,OBJECT **,RS_IMDOPE *);

void	menu_tune(OBJECT *);
void	menu_enable(OBJECT *,boolean,boolean);

void	graf_rt_slide_box(OBJECT *,int,int,int,int,int,int,int,int,int,int (*foo)(OBJECT *,int,int));
int 	graf_rt_rubberbox(int,int,GRECT *,int *,int *,void (*foo)(int *));
void	graf_arrows(DIAINFO *,int,int,int,int,int,int);

int		Event_Multi(EVENT *,long);
int	 	X_Form_Do(DIAINFO **,int,int (*foo1)(EVENT *),boolean (*foo2)(EVENT *));

boolean	init_gem(void);
void	exit_gem(void);

boolean open_work(int *,int *);
void    close_work(int);

boolean	open_rsc(char *);
void	close_rsc(void);

void	fix_objects(OBJECT *,int);
void	scale_image(OBJECT *,int);
void	trans_image(OBJECT *);

boolean open_dialog(OBJECT *,DIAINFO *,char *,boolean,boolean,int);
void	close_dialog(DIAINFO *,boolean);

int		xdialog(OBJECT *,char *,boolean,boolean,int);
int		Popup(OBJECT *,OBJECT *,int,int,int,int,int,boolean);

void	dial_col(int,int,int,int,int,int,int);
void	dial_opt(boolean,boolean);
void	title_opt(boolean,int,int);

void	radio_image(int,int *,int *);
void	check_image(int,int *,int *);
void	arrow_image(int,int *,int *,int *,int *,int *,int *,int *,int *);
void	cycle_image(int,int *);

void	create_cookie(COOKIE *,long,long);
boolean	new_cookie(COOKIE *);
boolean	get_cookie(long,long *);
void	remove_cookie(long);
void	move_cookiejar(long *,long);
long	cookie_size(void);

char	*getenv(const char *);
int		putenv(const char *);

int		scan_2_ascii(int,int);

int		min(int,int);
int		max(int,int);

void	Min(int *,int);
void	Max(int *,int);

void 	mfdb(MFDB *,int *,int,int,int,int);
long 	count_size(MFDB *);

#endif
