
#include <string.h>
#include <stdio.h>
#include <e_gem.h>

char *strmfp(char *,char *, char *);

int	scrp_init(char *path)
{
	register char scrap[256];
	register long handle,len;

	scrp_read(scrap);
	if (!(*scrap))
	{
		if (path)
			strcpy(scrap,path);
		else if ((path = getenv("CLIPBRD"))!=NULL)
			strcpy(scrap,path);
		else
		{
			register long ssp;

			strcpy(scrap,"X:\\CLIPBRD");
			ssp = Super(NULL);
			*scrap = (char) (*((int *) 0x446)+65);
			Super((void *) ssp);
		}
	}

	len = strlen(scrap);
	if (scrap[--len]=='\\')
		scrap[len]='\0';
	
	handle = Dcreate(scrap);
	if ((handle<0) && (handle!=-36))
	{
		scrp_write("");
		return(FALSE);
	}
	else
	{
		scrp_write(strcat(scrap,"\\"));
		return(TRUE);
	}
}

void scrp_clear()
{
	register char scrap[256];
	
	scrp_read(scrap);
	if (*scrap)
	{
		register DTA *dta=Fgetdta();
		register char xpath[256],xname[256];

		strmfp(xpath,scrap,"SCRAP.*");
		if (!Fsfirst(xpath,0))
			do
			{
				strmfp(xname,scrap,dta->d_fname);
				remove(xname);
			}
			while (!Fsnext());
	}
}

int	scrp_length()
{
	register char scrap[256];
	
	scrp_read(scrap);
	if (*scrap)
	{
		register DTA *dta=Fgetdta();
		register char xpath[256];

		strmfp(xpath,scrap,"SCRAP.*");
		if (!Fsfirst(xpath,0))
		{
			register long length = 0;
			do
				length += dta->d_length;
			while (!Fsnext());
			return ((int) ((length+512)>>10));
		}
	}
	return (0);
}

int	scrp_find(char *extension,char *filename)
{
	register char scrap[256];
	
	scrp_read(scrap);
	if (*scrap)
	{
		register DTA  *dta=Fgetdta();
		register char xpath[256];
		register int  c = 0;

		strcat(strmfp(xpath,scrap,"SCRAP."),extension);
		if(!Fsfirst(xpath,0))
		{
			c++;
			strmfp(filename,scrap,dta->d_fname);
			while (!Fsnext()) c++;
			return (c);
		}
	}
	return (0);
}

char *strmfp(char *dest,char *path,char *file)
{
	register char *last;
	
	if (path)
		strcpy(dest,path);

	last = dest + (int) (strlen(dest)-1);
	if (*last!='\\')
	{
		*last = '\\';
		*last++ = '\0';
	}

	strcat(dest,file);
	return(dest);
}
