#include "a:printf.h"
#include "a:stdio.h"
#include "as.h"


andor(opskel,opsk2)
unsigned    opskel,opsk2;
{
/*
       process AND,OR
       <EA>,DN DN,<EA>  DATA,<EA>
*/

        /* check for error - can't be An */

        if (op1ea == 2 || op2ea == 2)
                return 3;

        if (op1ea == 6) {

                /* process DATA,<EA> */

                opskel = opsk2;

                if (op2ea == 6)
                        return 3;

                procop(&opnptr);
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;

                /* now get ,<EA> */

                if (op2ea == 0)  {
			if (op1ea == 1)
                        	return 0;

                        /* evaluate ,<EA> for complex address */

                        procop(&opnpt2);
                        objbuf[objwc + 1] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[objwc + 1] = opnwrd[3];
                                objbuf[objwc + 2] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] |= opskel;
                        return 0;
                }

                /* check for DATA,SR or DATA,CCR */

                if (op2ea < 7) {
                        objbuf[1] = opskel | ((op2ea - 1) * 8) | op2da;
                        return 0;
                }

                if (op2ea > 8)
                        return 3;

                if (imode == 1 && op2ea == 8) {
                        objbuf[1] = opskel | 0x3c;
                        return 0;
                }

                if (imode == 1 || imode == 3)
                        return 3;
        }

        if (op2ea != 1) {

                /* EVALUATE DN,<EA> */

                opskel = opskel + (op1da * 0x200) | 0x100;

                if (op2ea == 0) {
                        procop(&opnpt2);
                        objbuf[objwc + 1] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[objwc + 1] = opnwrd[3];
                                objbuf[objwc + 2] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] |= opskel;
                        return 0;
                }

                objbuf[1] = opskel | op2da | ((op2ea - 1) * 8);
                return 0;
        }

        /* PROCESS <EA>,DN */

        opskel += (op2da * 0x200);

        if (op1ea != 0) {
                objbuf[1] = opskel | op1da | ((op1ea - 1) * 8);
                return 0;
        }

        procop(&opnptr);
        objbuf[1] = opskel | opnwrd[1];
        objbuf[2] = opnwrd[2];

        if (opnwc == 2) {
                objbuf[2] = opnwrd[3];
                objbuf[3] = opnwrd[2];
        }

        objwc += opnwc;
        return 0;
}


eor(opskel,opsk2)
unsigned    opskel,opsk2;
{
/*
       process EOR
       DN,<EA> DATA,<EA>
*/

        /* check for errors - can't be An */

        if (op1ea == 2 || op2ea == 2)
                return 3;

        if (op1ea == 6) {
                opskel = opsk2;

                if (op2ea == 6)
                        return 3;

                procop(&opnptr);
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;

                /* now that we have immediate data get ,<EA> */

                if (op2ea == 0)  {
			if (op1ea == 1)
				return 0;

                        /* evaluate ,<EA> for complex address */

                        procop(&opnpt2);
                        objbuf[objwc + 1] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[objwc + 1] = opnwrd[3];
                                objbuf[objwc + 2] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] |= opskel;
                        return 0;
                }

                /* check for DATA,SR or DATA,CCR */

                if (op2ea < 7) {
                        objbuf[1] = opskel | ((op2ea - 1) * 8) | op2da;
                        return 0;
                }

                if (op2ea > 8)
                        return 3;

                if (imode == 1 && op2ea == 8) {
                        objbuf[1] = opskel | 0x3c;
                        return 0;
                }

                if (imode == 1 || imode == 3)
                        return 3;
        }

        if (op1ea != 1)
                return 3;

        if (op2ea == 0) {

                /* evaluate DN,<EA> */

                opskel = opskel + (op1da * 0x200) | 0x100;

                if (op2ea == 0) {
                        procop(&opnpt2);
                        objbuf[objwc + 1] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[objwc + 1] = opnwrd[3];
                                objbuf[objwc + 2] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] |= opskel;
                        return 0;
                }

                objbuf[1] = opskel | op2da | ((op2ea - 1) * 8);
                return 0;
        }

        objbuf[1] = opskel + ((op1ea - 1) * 0x200) + op2da + ((op1ea - 1) * 8);
        return 0;
}


rotate(opskel)
unsigned    opskel;
{
/*
       process ROTATES and SHIFTS
       DX,DY   DATA,DY  <EA>
*/

        if (op1ea == 1 && op2ea == 1) {
                objbuf[1] = opskel | 0x20 | (op1da * 0x200) | op2da;
                return 0;
        }

        if ((op1ea == 6 && op2ea == 1) || (op1ea == 0 && op2ea == 1)) {
                procop(&opnptr);

                if (opnwrd[2] < 1 || opnwrd[2] > 8)
                        return 3;

                if (opnwrd[2] == 8)
                        opnwrd[2] = 0;

                objbuf[1] = opskel + (opnwrd[2] * 0x200) + op2da;
                return 0;
        }

        /* process <EA> */

        if (op1ea != 0) {
                if (op1ea < 3 || op1ea > 5)
                        return 3;

                objbuf[1] = opskel + ((op1ea - 1) * 8) + op1da;
                return 1;
        }

        procop(&opnptr);
        objbuf[1] = opskel + opnwrd[1];
        objbuf[2] = opnwrd[2];

        if (opnwc == 2) {
                objbuf[2] = opnwrd[3];
                objbuf[3] = opnwrd[2];
        }

        objwc += opnwc;
        return 1;
}


branch(opskel)
unsigned    opskel;
{
/*
       process BRANCH
       <label>
*/
        int     itemp;

        if (opnptr == 0 || op1ea != 0)
                return 3;

        dbflg = 1;
        procop(&opnptr);

        /* check for forced short address mode */

        if (imode == 4) {
                objwc = 1;
                objbuf[1] = opskel | (opnwrd[2] & 0xff);
                dbflg = 0;
                return 1;
        }

        /* CHECK FOR FWD SYMBOL OR REF BEFORE DEFINITION */

        if (opnflg == 1) {
                objbuf[1] = opskel;
                objbuf[2] = opnwrd[2];
                objwc = 2;
                dbflg = 0;
                return 1;
        }

        /* CHECK FOR SHORT BRANCH */

        itemp = opnwrd[2];
        if (itemp >= -126 && itemp <= 129 && itemp != -2) {
                objwc = 1;
                objbuf[1] = opskel | (opnwrd[2] & 0xff);
                dbflg = 0;
                return 1;
        }

        if (imode == 4)
                error(404);

        /* ELSE GENERATE TWO WORD BRANCH */

        objbuf[1] = opskel;
        objbuf[2] = opnwrd[2];
        objwc = 2;
        dbflg = 0;
        return 1;
}


bitmod(opskel,opsk2)
unsigned    opskel,opsk2;
{
/*
       process BIT MODIFICATION
       DN,<EA> DATA,<EA>
*/
        unsigned    tflg;
        long        ltemp;

        if ((op1ea != 1 && op1ea != 6) || op2ea == 2 || op2ea > 5)
                return 3;

        if (op1ea == 6) {       /* imm,<EA> */
                procop(&opnptr);

                ltemp = asn(opnwrd[2],opnwrd[3]);
                if (op2ea == 1)  {
                        if (ltemp < 0l || ltemp > 31l)
                                return 3;
		}
                else  {
                        if (ltemp < 0l || ltemp > 7l)
                                return 3;
		}

                objbuf[2] = opnwrd[2];
                ++objwc;

                if (op2ea == 0) {       /* #imm,complex <EA> */
                        tflg = rflg;
                        rflg = 1;
                        procop(&opnpt2);
                        rflg = tflg;
                        objbuf[3] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[3] = opnwrd[3];
                                objbuf[4] = opnwrd[2];
                        }

                        objwc += opnwc;
                        objbuf[1] = opsk2 + (opnwrd[1] & 0x3f);
                        return 1;
                }

                /* simple <EA> */

                objbuf[1] = opsk2 + op2da + ((op2ea - 1) * 8);
                return 1;
        }

        if (op2ea == 0) {       /* Dn,complex <EA> */
                tflg = rflg;
                rflg = 1;
                procop(&opnpt2);
                rflg = tflg;
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;
                objbuf[1] = opskel | (opnwrd[1] & 0x3f) | (op1da * 0x200);
                return 1;
        }

        /* SIMPLE EA'S */

        objbuf[1] = opskel | (op1da * 0x200) | op2da | ((op2ea - 1) * 8);
        return 1;
}


mult(opskel)
unsigned    opskel;
{
/*
          process MULT DIV and CHK
          <EA>,DN
*/

        if (op2ea != 1 || op1ea == 2)
                return 3;

        if (op1ea != 0 && op1ea != 6) {
                if (op1ea > 6)
                        return 3;

                opskel = opskel + ((op1ea - 1) * 8) + op1da;
        }
        else {
                procop(&opnptr);
                opskel += opnwrd[1];
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;
        }

        objbuf[1] = opskel + (op2da * 0x200);
        return 1;
}


sglea(opidx,opskel)
unsigned    opidx,opskel;
{
/*
	process opcode <EA>
	CHK FOR CLR,NEG,NOT,TST,NEGX
*/
        unsigned    tflg;

        if (opidx == 17 || opidx == 24 || opidx == 26 || opidx == 47 || opidx == 23) {
                if (opidx == 23 && imode != 0 || op1ea == 2 || op1ea >= 6)
                        return 3;

                if (opidx != 23) {
                        if (imode == 3)
                                opskel += 0x80;

			if (imode == 2 || imode == 0)
                                opskel += 0x40;
                }

                if (op1ea == 0) {
                        tflg = rflg;
                        rflg = 1;
                        procop(&opnptr);
                        objbuf[1] = opskel | opnwrd[1];
                        objbuf[2] = opnwrd[2];

                        if (opnwc == 2) {
                                objbuf[2] = opnwrd[3];
                                objbuf[3] = opnwrd[2];
                        }

                        objwc += opnwc;
                        rflg = tflg;
                        return 1;
                }

                /* PROCESS REG opERAND */

                objbuf[1] = opskel | op1da | ((op1ea - 1) * 8);
                return 1;
        }

        /* PROCESS JSR or JMP */

        if (op1ea != 0 && op1ea != 3)
                return 3;

        if (op1ea == 3) {
                objbuf[1] = opskel | op1da | 0x10;
                return 1;
        }

        /* GENERATE EXTENSION WORDS AS NECESSARY */

        procop(&opnptr);
        objbuf[1] = opskel | opnwrd[1];
        objbuf[2] = opnwrd[2];

        if (opnwc == 2) {
                objbuf[2] = opnwrd[3];
                objbuf[3] = opnwrd[2];
        }

        objwc += opnwc;
        return 1;
}


decrbr(opskel)
unsigned    opskel;
{
/*
          process DECR and BRANCH
          DN,<label>
*/
	int	i;

        if (op1ea != 1 || op2ea != 0)
                return 3;

        objbuf[1] = opskel + op1da;
        i = rflg;
        rflg = 0;
        dbflg = 1;
        scanpt = opnpt2;
        procop(&opnpt2);
        objbuf[2] = opnwrd[2];
        rflg = i;
        objwc = 2;
        dbflg = 0;
        return 1;
}


exg(opskel)
unsigned    opskel;
{
/*
          process EXG
*/
        if (op1ea == 0 || op1ea > 2 || op2ea == 0 || op2ea > 2)
                return 3;

        opskel += op2da;
        opskel += (op1da * 0x200);

        if (op1ea == 1 && op2ea == 1)
                objbuf[1] = opskel + 0x140;

        if (op1ea == 2 && op2ea == 2)
                objbuf[1] = opskel + 0x148;

        if (op1ea == op2ea)
                return 1;

        objbuf[1] = opskel + 0x188;
        return 1;
}


ext(opidx,opskel)
unsigned    opidx,opskel;
{
/*
          process EXT and SWAP
          DN
*/
        if (opidx != 27)
                if (imode == 3)
                        opskel |= 0x40;

        if (op1ea != 1)
                return 3;

        objbuf[1] = opskel + op1da;
        return 1;
}


lea(opskel)
unsigned    opskel;
{
/*
          process LEA
          <EA>,AN
*/
        if (op1ea == 0) {
                procop(&opnptr);
                objbuf[1] = opskel | opnwrd[1] | (op2da << 9);
                objbuf[2] = opnwrd[2];

                if (opnwc == 2) {
                        objbuf[2] = opnwrd[3];
                        objbuf[3] = opnwrd[2];
                }

                objwc += opnwc;
                return 1;
        }

        if (op1ea == 3) {
                objbuf[1] = opskel | (op2da << 9) | op1da;
                objbuf[1] |= ((op1ea - 1) * 8);
                return 1;
        }

        return 3;
}


link(opskel)
unsigned    opskel;
{
/*
          process LINK
          AN,<DISPLACEMENT>
*/
        if (op1ea != 2 && op2ea != 6)
                return 3;

        procop(&opnpt2);

        if (opnwrd[3] == 0 || opnwrd[3] == -1) {
                objwc = 2;
                objbuf[1] = opskel + op1da;
                objbuf[2] = opnwrd[2];
                return 1;
        }

        return 3;
}


trap(opskel)
unsigned    opskel;
{
/*
          process TRAP
          <VECTOR>
*/
        if (op1ea != 6)
                return 3;

        procop(&opnptr);

        if (opnwc != 1 || opnwrd[2] > 16)
                return 3;

        objbuf[1] = opskel + opnwrd[2];
        return 1;
}


stop(opskel)
unsigned    opskel;
{
/*
          process STOP
          #<SR>
*/
        if (op1ea != 6)
                return 3;

        procop(&opnptr);

        if (opnwc != 1)
                return 3;

        objbuf[1] = opskel;
        objbuf[2] = opnwrd[2];
        objwc = 2;
        return 1;
}


abcd(opskel)
unsigned    opskel;
{
/*
          process ABCD,SBCD,ADDX,SUBX
          DY,DX -(AY),-(AX)
*/

        if (op1ea == 1 && op2ea == 1) {
                if (op1ea == 5)
                        opskel += 8;

                opskel += op2da;
                objbuf[1] = opskel + op1da * 0x200;
                return 1;
        }

        if (op1ea != 5 || op2ea != 5)
                return 3;

        if (op1ea == 5)
                opskel += 8;

        opskel += op2da;
        objbuf[1] = opskel + op1da * 0x200;

        return 1;
}


unlk(opskel)
unsigned    opskel;
{
/*
          process UNLK
          AN
*/
        if (op1ea != 2)
                return 3;

        objbuf[1] = opskel+op1da;
        return 1;
}
