#include "a:printf.h"
#include "a:stdio.h"
#include "as.h"


decopc(opidx,opskel,opsk2)
unsigned	*opidx,*opskel,*opsk2;
{
/*
       Lookup Op-code
       Op-code starts at srclne[opptr]
*/

        static char psuop3[] = {'O','R','G','E','N','D','E','Q','U',
                                'N','A','M','S','E','T'};

        static char psuop4[] = {'R','O','R','G','P','A','G','E',
                                'L','I','S','T'};

        static char psuop5[] = {'N','L','I','S','T'};

        static char op4big[] = {'M','O','V','E','B','C','H','G',
                'B','C','L','R','B','S','E','T','B','T','S','T',
                'R','O','X','L','R','O','X','R'};

        static int op4opc[]  = {0x0000,0x0000,0x0140,0x0840,0x0180,
                                0x0880,0x01c0,0x08c0,0x0100,0x0800,
                                0xe110,0xe5c0,0xe010,0xe4c0};

        static int op4pty[]  = {3,10,10,10,10,8,8};

        static char op3big[] = {'A','D','D','A','S','L','A','S','R',
                    'S','U','B','A','N','D','C','M','P','E','O','R',
                    'L','S','L','L','S','R','R','O','L','R','O','R'};

        static int op3opc[]  = {0xd000,0x0600,0xe100,0xe1c0,0xe000,
                                0xe0c0,0x9000,0x0400,0xc000,0x0200,
                                0xb000,0x0c00,0xb100,0x0a00,0xe108,
                                0xe3c0,0xe008,0xe2c0,0xe118,0xe7c0,
                                0xe018,0xe6c0};

        static int op3pty[]  = {4,8,8,4,6,5,7,8,8,8,8};

        static char op3nam[] = {
                'B','E','Q','B','N','E','B','P','L',
                'B','M','I','B','G','T','B','L','T',
                'B','G','E','B','L','E','B','H','I',
                'B','L','S','B','C','S','B','C','C',
                'B','V','S','B','V','C','B','R','A',
                'B','S','R','C','H','K','C','L','R',
                'E','X','G','E','X','T','J','M','P',
                'J','S','R','L','D','M','L','E','A',
                'N','E','G','N','O','P','N','O','T',
                'P','E','A','R','T','E','R','T','R',
                'R','T','S','S','E','Q','S','N','E',
                'S','P','L','S','M','I','S','G','T',
                'S','L','T','S','G','E','S','L','E',
                'S','H','I','S','L','S','S','C','S',
                'S','C','C','S','T','M','S','V','S',
                'S','V','C','T','A','S','T','S','T'};

        static int op3ops[]  = {0x6700,0x6600,0x6a00,0x6b00,
                                0x6e00,0x6d00,0x6c00,0x6f00,
                                0x6200,0x6300,0x6500,0x6400,
                                0x6900,0x6800,0x6000,0x6100,
                                0x4180,0x4200,0xc000,0x4880,
                                0x4ec0,0x4e80,0x4c80,0x41c0,
                                0x4400,0x4e71,0x4600,0x4840,
                                0x4e73,0x4e77,0x4e75,0x57c0,
                                0x56c0,0x5ac0,0x5bc0,0x5ec0,
                                0x5dc0,0x5cc0,0x5fc0,0x52c0,
                                0x53c0,0x55c0,0x54c0,0x4880,
                                0x59c0,0x58c0,0x4ac0,0x4a00};

        static int op3typ[]  = {9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,11,12,
                                14,15,12,12,21,16,12,2,12,12,2,2,2,12,
                                12,12,12,12,12,12,12,12,12,12,12,12,12,
                                12,12,12};

        static char op4nam[] = {'A','B','C','D','A','D','D','X',
                'D','B','R','A','D','B','H','I','D','B','L','S',
                'D','B','C','C','D','B','C','S','D','B','N','E',
                'D','B','E','Q','D','B','V','C','D','B','V','S',
                'D','B','P','L','D','B','M','I','D','B','G','E',
                'D','B','L','T','D','B','G','T','D','B','L','E',
                'D','I','V','S','D','I','V','U','L','I','N','K',
                'M','U','L','S','M','U','L','U','N','B','C','D',
                'N','E','G','X','S','B','C','D','S','T','O','P',
                'S','U','B','X','S','W','A','P','T','R','A','P',
                'U','N','L','K'};

        static int op4ops[]  = {0xc100,0xd100,0x51c8,0x52c8,
                                0x53c8,0x54c8,0x55c8,0x56c8,
                                0x57c8,0x58c8,0x59c8,0x5ac8,
                                0x5bc8,0x5cc8,0x5dc8,0x5ec8,
                                0x5fc8,0x81c0,0x80c0,0x4e50,
                                0xc1c0,0xc0c0,0x4800,0x4000,
                                0x8100,0x4e72,0x9100,0x4840,
                                0x4e40,0x4e58};

        static int op4typ[]  = {19,19,13,13,13,13,13,13,13,13,
                                13,13,13,13,13,13,13,11,11,17,
                                11,11,12,12,19,22,19,15,18,20};

        static char op5nam[] = {'M','O','V','E','M',
                                'R','E','S','E','T',
                                'T','R','A','P','V'};

        static int op5ops[]  = {0x4880,0x4e70,0x4e76};

        int     i,optyp;
        
        /* start of op-code processing */

        *opskel = *opsk2 = 0;
        scanpt = opptr;

        if (opclen <= 1 || opclen > 5)
                return 0;

        /* process op-code by size */

        switch (opclen) {

                /* two character Op-codes */

                case 2:

                        if (srclne[opptr] == 'O' && srclne[opptr+1] == 'R') {
                                *opidx = 0;
                                *opskel = 0x8000;
                                return 6;
                        }

                        if (srclne[opptr] == 'D') {
                                if (srclne[opptr+1] == 'C') {
                                        *opidx = 1;
                                        return 1;
                                }

                                if (srclne[opptr+1] == 'S') {
                                        *opidx = 2;
                                        return 1;
                                }
                        }
                        return 0;

                /* three character Op-codes */

                case 3:

                        optyp = oplook(5,3,psuop3,op3typ,0,opidx);
                        if (optyp == 1) {
                                *opidx += 3;
                                return 1;
                        }

                        optyp = oplook(11,3,op3big,op3pty,1,opidx);
                        if (optyp != 0) {
                                *opskel = op3opc[(*opidx)*2];
                                *opsk2 = op3opc[((*opidx)*2)+1];
                                return optyp;
                        }

                        optyp = oplook(48,3,op3nam,op3typ,1,opidx);
                        *opskel = op3ops[*opidx];
                        return optyp;

                /* four character Op-codes */

                case 4:
                        optyp = oplook(3,4,psuop4,op3nam,0,opidx);
                        if (optyp == 1) {
                                *opidx += 8;
                                return 1;
                        }

                        optyp = oplook(7,4,op4big,op4pty,1,opidx);
                        if (optyp != 0) {
                                *opskel = op4opc[(*opidx)*2];
                                *opsk2 = op4opc[((*opidx)*2)+1];
                                return optyp;
                        }

                        optyp = oplook(30,4,op4nam,op4typ,1,opidx);
                        if (optyp == 0) 
                                return 0;

                        *opskel = op4ops[*opidx];
                        return optyp;

                /* five character Op-codes */

                case 5:
                        optyp = oplook(1,5,psuop5,op3typ,0,opidx);
                        if (optyp == 1) {
                                *opidx = 11;
                                return 1;
                        }

                        optyp = oplook(3,5,op5nam,op5ops,1,opidx);
                        if (optyp == 0)
                                return 0;

                        if (*opidx == 0)
                                optyp = 21;
                        else
                                optyp = 2;

                        *opskel = op5ops[*opidx];
                        return optyp;
        }
}


oplook(isiz,istep,itbl,ityp,ipsf,opidx)
unsigned	isiz,istep,ipsf,*ityp,*opidx;
char            *itbl;
{
	int     i,j,is,found;

        for (i = 0; i < isiz; ++i) {
                is = i * istep;
                found = TRUE;

                for (j = 0; j < istep; ++j) {
                        if (srclne[opptr+j] != itbl[is+j]) {
                                found = FALSE;
                                break;
                        }
                }

                if (found)
                        break;
        }

        if (!found)
                return 0;

        *opidx = i;

        if (!ipsf)
                return 1;
        else
                return ityp[i];
}


parse()
{

/*
	Parse incoming Source line

	IN:
		srclne = line to be parsed
		lnelen = length of source line

	OUT:
		label	= Label field (label[0] = 0 if no label)
		opptr	= pointer to Op-code field
		opclen	= length of Op-code field not including mode
		modptr	= pointer to Mode field
		imode	= 0  no Mode field
			= 1 .B
			= 2 .W
			= 3 .L
			= 4 .S

		opnptr	= pointer to first operand
		opnpt2	= pointer to second operand
		cmtptr	= pointer to comment field
		cmtflg	= comment flag - TRUE if line is comment only
		prflg	= parse flag - zero if error detected
*/

        int     i,ic,ipf;

        ipf = imode = label[0] = scanpt = opclen =
	opptr = opnptr = opnpt2 = modptr = cmtptr = 0;
	cmtflg = FALSE;
	prflg = 1;

        /* if null line ignore it */

        if (!lnelen) {
                prflg = 0;
                return;
        }

        /* check for a comment line */

        if (srclne[0] == '*') {
                cmtflg = TRUE;
                return;
        }

        /* see if Label present */

        if (srclne[scanpt] != ' ' && srclne[scanpt] != '\t') {

        /* Labels must start with A-Z */

                if ((srclne[0] < 'A' || srclne[0] > 'Z') &&
                    (srclne[0] != '@' && srclne[0] != '_')) {
                        error(202);
                        return;
                }

                for (scanpt = 0; scanpt < SYMSIZ; ++scanpt) {
                        if ((srclne[scanpt] >= '0' &&
                            srclne[scanpt] <= '9') ||
                           (srclne[scanpt] >= 'A' &&
                            srclne[scanpt] <= 'Z') ||
                            srclne[scanpt] == '_' ||
                            srclne[scanpt] == '@')
                                label[scanpt] = srclne[scanpt];
                        else
                                break;
                }

                label[scanpt] = EOS;

                if (scanpt == 2) {
                        if (label[0] == 'A' || label[0] == 'D') {
                                if (label[1] >= '0' && label[1] <= '7') {
                                        prflg = 0;
                                        error(204);
                                        return;
                                }
                        }

                        if (label[0] == 'S') {
                                if (label[1] == 'P' || label[1] == 'R') {
                                        prflg = 0;
                                        error(204);
                                        return;
                                }
                        }
                }
                else if (scanpt == 3) {
                        if (label[0] == 'C' && label[1] == 'C' &&
                            label[2] == 'R') {
                                prflg = 0;
                                error(204);
                                return;
                        }

                        if (label[0] == 'U' && label[1] == 'S' &&
                            label[2] == 'P') {
                                prflg = 0;
                                error(204);
                                return;
                        }
                }
        }

        if (srclne[scanpt] != ' ' && srclne[scanpt] != ':' &&
            srclne[scanpt] != '\t' && srclne[scanpt] != 0) {
                prflg = 0;
                error(205);
                return;
        }

        if (srclne[scanpt] == EOS) {
                prflg = 1;
                return;
        }

        ++scanpt;
        prflg = 1;
        while (srclne[scanpt] == ' ' || srclne[scanpt] == '\t')
                ++scanpt;

        if (srclne[scanpt] == EOS)
                return;

        opptr = scanpt;
        for (i = 0; i < 5; ++i) {
                if (srclne[scanpt] < 'A' || srclne[scanpt] > 'Z')
                        break;

                ++scanpt;
        }

        /* length of op-code is one less then scanned */

        opclen = i;

        /* check for end of line */

        if (srclne[scanpt] == EOS)
                return;

        /* check for XXX.X */

        if (srclne[scanpt] == '.') {
                ++scanpt;
                switch (srclne[scanpt]) {
                        case 'S':       ++imode;
                        case 'L':       ++imode;
                        case 'W':       ++imode;
                        case 'B':       ++imode;
                                        modptr = scanpt++;
                                        break;
                        default:        opptr = prflg = 0;
                                        error(207);
                                        return;
                }
        }

        if (srclne[scanpt] != ' ' && srclne[scanpt] != '\t') {
                opptr = prflg = 0;
                error(206);
                return;
        }

        /* parse possible first operand */

        while ((ic = srclne[++scanpt]) == ' ' || ic == '\t') {
                if (ic == EOS)
                        return;
        }

        if (ic == '$' || ic == '*' || ic == '(' || ic == '\'' ||
            ic == '-' || ic == '#' || (ic >= '0' && ic <= '9') ||
            ic == '@' || ic == '_' || (ic >= 'A' && ic <= 'Z'))

	/* save pointer to start of first operand */

                opnptr = scanpt;
        else {
                opptr = prflg = 0;
                error(206);
                return;
        }

	/* look for quotes */

        if (srclne[scanpt] == '\'' || srclne[scanpt+1] == '\'') {
                if (srclne[scanpt+1] == '\'')
                        ++scanpt;

                while (srclne[++scanpt] != '\'')
                        if (srclne[scanpt] == EOS)
                                return;
        }

        while (ic = srclne[++scanpt]) {
                if (ic == ' ')
                        break;

                if (ic == '(')
                        ipf = 1;

                if (ic == ')')
                        ipf = 0;

                if (ic == ',' && ipf == 0)
                        break;
        }

        if (ic == EOS)
                return;

        if (ic == ' ') {
                while (srclne[++scanpt] == ' ')
			;
                if (srclne[scanpt] == EOS)
                        return;

                cmtptr = scanpt;
                return;
        }

        /* save start of possible second operand */

        opnpt2 = ++scanpt;
        if (srclne[scanpt] == EOS)
                return;

        if (srclne[scanpt] == '\'') {
                while (srclne[++scanpt] != '\'')
                        if (srclne[scanpt] == EOS)
                                return;
                ++scanpt;
        }

        while (srclne[++scanpt] != ' ')
                if (srclne[scanpt] == EOS)
                        return;

        while (srclne[++scanpt] == ' ')
		;

        cmtptr = scanpt;
        return;
}
