         NAME      CLOSER
         PAGE      55,132
         TITLE     'CLOSER - SHOW BUG IN PC-DOS FUNCTION 10H'
;
; THIS PROGRAM DEMONSTRATES A SUBTLE BUT DANGEROUS BUG IN THE
; PC-DOS CLOSE FILE FUNCTION 10H.  IF A CLOSE REQUEST IS ISSUED
; USING A FILE CONTROL BLOCK THAT HAS NOT BEEN PREVIOUSLY
; ACTIVATED BY A SUCCESSFUL OPEN COMMAND, THE FILE'S LENGTH
; WILL BE TRUNCATED TO ZERO AND THE CLUSTERS PREVIOUSLY ASSIGNED
; TO THE FILE ARE LEFT FLOATING.
;
; RAY DUNCAN, NOVEMBER 1983

CR       EQU       0DH       ;ASCII CARRIAGE RETURN
LF       EQU       0AH       ;ASCII LINE FEED

CSEG     SEGMENT   PARA PUBLIC 'CODE'

         ASSUME    CS:CSEG,DS:DATA,ES:DATA,SS:STACK

CLOSER   PROC      FAR
         PUSH      DS        ;SAVE DS:0000 FOR FINAL
         XOR       AX,AX     ;RETURN TO PC-DOS
         PUSH      AX

         MOV       AX,DATA   ;MAKE OUR DATA AREA
         MOV       DS,AX     ;ADDRESSABLE
         MOV       ES,AX

                             ;NOW CREATE FILE QUACK.DAT
         MOV       AH,16H
         MOV       DX,OFFSET FCB
         INT       21H
         OR        AL,AL     ;CREATE SUCCESSFUL?
         JNZ       CLOSER8   ;NO,JUMP
         MOV       AH,9      ;YES,PRINT SUCCESS MESSAGE
         MOV       DX,OFFSET MSG1
         INT       21H

                             ;NOW SET THE RECORD LENGTH
                             ;TO 1024 BYTES AND WRITE
                             ;RANDOM DATA INTO THE
                             ;FILE (USING DEFAULT DTA)
         MOV       WORD PTR FCB+14,1024
         MOV       AH,15H
         MOV       DX,OFFSET FCB
         INT       21H
         OR        AL,AL     ;WAS WRITE SUCCESSFUL?
         JNZ       CLOSER8   ;NO,JUMP
         MOV       AH,9      ;YES,PRINT SUCCESS MESSAGE
         MOV       DX,OFFSET MSG2
         INT       21H

                             ;NOW CLOSE THE FILE SO THE
                             ;DIRECTORY WILL BE UPDATED
         MOV       AH,10H
         MOV       DX,OFFSET FCB
         INT       21H
         OR        AL,AL     ;CLOSE OPERATION SUCCESSFUL?
         JNZ       CLOSER8   ;NO,JUMP
         MOV       AH,9      ;YES,PRINT SUCCESS MESSAGE
         MOV       DX,OFFSET MSG3
         INT       21H

                             ;NOW CLEAR OUT THE FILE CONTROL
                             ;BLOCK EXCEPT FOR THE FILESPEC,
                             ;AS THOUGH THE FILE HAD NEVER
                             ;BEEN OPENED, AND THEN REQUEST
                             ;ANOTHER CLOSE OPERATION.

         MOV       DI,OFFSET FCB+12
         MOV       CX,25
         XOR       AL,AL
         CLD
         REP STOSB           ;THIS ZEROS OUT THE FCB

         MOV       AH,10H    ;NOW CLOSE FILE AGAIN
         MOV       DX,OFFSET FCB
         INT       21H
         OR        AL,AL     ;CHECK STATUS
         JNZ       CLOSER8   ;BAD STATUS,JUMP

                             ;STATUS OK, PRINT FINAL
                             ;MESSAGE TO INSPECT DIRECTORY
         MOV       DX,OFFSET MSG4
         JMP       CLOSER9

CLOSER8:                     ;COME HERE IF UNEXPECTED
                             ;FAILURE OF DISK OPERATION
         MOV       DX,OFFSET MSG5

CLOSER9:                     ;PRINT MESSAGE AND EXIT
         MOV       AH,9
         INT       21H

         RET                 ;FAR RETURN TO PC-DOS

CLOSER   ENDP

CSEG     ENDS


STACK    SEGMENT   PARA STACK 'STACK'
         DB        64 DUP (?)
STACK    ENDS


DATA     SEGMENT   PARA PUBLIC 'DATA'

MSG1     DB        CR,LF
         DB        'FILE QUACK.DAT CREATED'
         DB        CR,LF,'$'

MSG2     DB        CR,LF
         DB        '1024 BYTES WRITTEN INTO QUACK.DAT'
         DB        CR,LF,'$'

MSG3     DB        CR,LF
         DB        'FILE QUACK.DAT CLOSED PROPERLY'
         DB        CR,LF,'$'

MSG4     DB        CR,LF,LF
         DB        'SECOND CLOSE OPERATION REQUESTED '
         DB        'ON FILE QUACK.DAT'
         DB        CR,LF
         DB        'INSPECT LENGTH OF FILE QUACK.DAT '
         DB        'ON DIRECTORY LISTING'
         DB        CR,LF
         DB        'THEN RUN CHKDSK WITH /F SWITCH TO '
         DB        'RECOVER LOST DISK CLUSTERS'
         DB        CR,LF,'$'

MSG5     DB        CR,LF
         DB        'UNEXPECTED FAILURE OF DISK OPERATION'
         DB        CR,LF,'$'

                             ;FILE CONTROL BLOCK
FCB      DB        0         ;USE DEFAULT DRIVE
         DB        'QUACK   DAT'
         DB        25 DUP (0)

DATA     ENDS

         END       CLOSER
