	TITLE	UNDOS		;UN-DOS A SYSTEM DISK
	PAGE	25,80		;25 LINES PER PAGE, 80 COLUMNS PER LINE
CODE	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE
EXTFCB	STRUC
FLAG	DB	0FFH		;EXTENDED FCB FLAG BYTE
RES1	DB	5 DUP (0)	;RESERVED FOR SYSTEM USE
ATTR	DB	06H		;ATTRIBUTE BYTE (HIDDEN, SYSTEM)
DRV	DB	0		;DRIVE NUMBER
FILE	DB	"        "      ;FILE NAME
EXT	DB	"   "           ;FILE EXTENSION
BLK	DW	0		;CURRENT BLOCK NUMBER
REC	DW	0		;LOGICAL RECORD SIZE OF FILE
SIZE1	DW	0		;LSB OF FILE SIZE
SIZE2	DW	0		;MSB OF FILE SIZE
DATE	DW	0		;DATE FILE WAS CREATED
TIME	DW	0		;TIME THE FILE WAS CREATED
RES2	DB	8 DUP (0)	;RESERVED FOR SYSTEM USE
RELREC	DB	0		;CURRENT RELATIVE RECORD NUMBER (IN BLOCK)
RREC1	DW	0		;LSB OF RELATIVE RECORD NUMBER
RREC2	DW	0		;MSB OF RELATIVE RECORD NUMBER
SAVE1	DW	0		;SAVE AREA ONE
SAVE2	DW	0		;SAVE AREA TWO
SAVE3	DW	0		;SAVE AREA THREE
EXTFCB	ENDS			;END OF EXTFCB STRUCTURE
INPUT	EQU	0C08H		;CLEAR KEYBOARD BUFFER THEN INPUT CODE
PRINT	EQU	09H		;PRINT STRING FUNCTION CODE
OPEN	EQU	0FH		;OPEN FILE FUNCTION CODE
CLOSE	EQU	10H		;CLOSE FILE FUNCTION CODE
GETDRV	EQU	19H		;GET CURRENT DEFAULT DRIVE FUNCTION CODE
SETDTA	EQU	1AH		;SET DISK TRANSFER ADDRESS FUNCTION CODE
TABLE	EQU	1CH		;GET ALLOCATION TABLE ADDRESS FUNCTION CODE
RBLKRD	EQU	27H		;RANDOM BLOCK READ FUNCTION CODE
RBLKWR	EQU	28H		;RANDOM BLOCK WRITE FUNCTION CODE
DSPEC	EQU	BYTE PTR 5CH	;POINTER TO DRIVE SPECIFICATION
PARAM	EQU	BYTE PTR 5DH	;POINTER TO INPUT PARAMETER
BAD	EQU	0FFH		;ERROR CODE
CONV	EQU	40H		;BINARY TO ASCII CONVERSION FACTOR
ZERO	EQU	00H		;ZERO BYTE
ONE	EQU	01H		;ONE WORD
BLANK	EQU	20H		;ASCII BLANK
CRLF	EQU	0A0DH		;ASCII LINE FEED, CARRIAGE RETURN
BIOMAX	EQU	8000H		;MAXIMUM BYTE COUNT FOR IBMBIO FILE
DOSMAX	EQU	2000H		;MAXIMUM BYTE COUNT FOR IBMDOS FILE
EXIT	MACRO			;TERMINATE INTERRUPT MACRO
	INT	20H		;DO THE TERMINATE INTERRUPT 20
	ENDM			;END OF THE EXIT MACRO
DOS	MACRO			;DOS INTERRUPT CALL MACRO
	INT	21H		;DO THE DOS INTERRUPT 21
	ENDM			;END OF DOS MACRO
	ORG	100H		;ORIGIN ADDRESS FOR COM FILES
UNDOS	PROC	NEAR		;ENTRY POINT FROM DOS 1.1
	JMP	SHORT START	;GO TO THE START-UP POINT
ILLEGAL LABEL	NEAR		;ILLEGAL PARAMETER CODE SECTION
	MOV	DX,OFFSET MSG2	;POINT TO ILLEGAL PARAMETER MESSAGE
	JMP	MSGRET		;GO PRINT THE MESSAGE AND RETURN TO DOS
INVALID LABEL	NEAR		;INVALID DRIVE CODE SECTION
	MOV	DX,OFFSET MSG1	;POINT TO INVALID DRIVE MESSAGE
	JMP	MSGRET		;GO PRINT THE MESSAGE AND RETURN TO DOS
INSERT	LABEL	NEAR		;INSERT CORRECT DISK SECTION
	MOV	AL,[DEFAULT]	;GET CURRENT DEFAULT DRIVE NUMBER
	ADD	AL,CONV 	;CONVERT DRIVE NUMBER TO ASCII
	MOV	[DRIVE],AL	;STUFF DRIVE NUMBER IN MESSAGE
	MOV	DX,OFFSET MSG3	;POINT TO INSERT SYSTEM DISK MESSAGE
	MOV	AH,PRINT	;GET PRINT STRING FUNCTION CODE
	DOS			;PRINT THE MESSAGE
	MOV	AX,INPUT	;LOAD AX WITH CLEAR BUFFER AND INPUT CODE
	DOS			;GO WAIT FOR ANY CHARACTER
	XOR	AL,AL		;ZERO THE AL REGISTER
START	LABEL	NEAR		;INITIAL STARTING CODE (FROM ENTRY POINT)
	CMP	[DS:PARAM],BLANK;CHECK FOR ENTERED FILENAME OR PARAMETER
	JNZ	ILLEGAL 	;JUMP IF FILENAME OR PARAMETER ENTERED
	CMP	AL,BAD		;CHECK FOR INVALID DRIVE SPECIFICATION
	JZ	INVALID 	;JUMP IF INVALID DRIVE SPECIFIED
	MOV	AL,[DS:DSPEC]	;GET THE REQUESTED DRIVE NUMBER
	MOV	[IBMDOS].DRV,AL ;PUT DRIVE NUMBER IN IBMDOS.COM FCB
	MOV	[IBMBIO].DRV,AL ;PUT DRIVE NUMBER IN IBMBIO.COM FCB
	MOV	AH,OPEN 	;LOAD AH WITH OPEN FILE FUNCTION CODE
	MOV	DX,OFFSET IBMBIO;POINT TO FCB FOR IBMBIO.COM FILE
	DOS			;ATTEMPT TO OPEN THE FILE IBMBIO.COM
	OR	AL,AL		;CHECK TO SEE IF FILE IS PRESENT
	JNZ	INSERT		;JUMP IF THIS IS NOT A GOOD DISK
	MOV	DX,OFFSET IBMDOS;POINT TO FCB FOR IBMDOS.COM FILE
	MOV	AH,OPEN 	;LOAD AH WITH OPEN FILE FUNCTION CODE
	DOS			;ATTEMPT TO OPEN THE FILE IBMDOS.COM
	OR	AL,AL		;CHECK TO SEE IF FILE IS PRESENT
	JNZ	INSERT		;JUMP IF THIS IS NOT A GOOD DISK
	MOV	AH,SETDTA	;LOAD AH WITH SET DTA FUNCTION CODE
	MOV	DX,OFFSET DTA2	;POINT TO DISK TRANSFER ADDRESS FOR IBMBIO.COM
	DOS			;SET THE DISK TRANSFER ADDRESS
	MOV	AX,ONE		;LOAD AX WITH ONE
	MOV	[IBMBIO].REC,AX ;SET IBMBIO.COM RECORD SIZE TO ONE
	MOV	[IBMDOS].REC,AX ;SET IBMDOS.COM RECORD SIZE TO ONE
	MOV	BX,OFFSET IBMBIO;POINT TO FCB FOR IBMBIO.COM
	MOV	CX,BIOMAX	;LOAD CX WITH MAXIMUM RECORD COUNT (BYTES)
	CALL	READ		;CALL ROUTINE TO READ IN THE FILE
	MOV	BX,OFFSET IBMBIO;POINT TO FCB FOR IBMBIO.COM
	MOV	DX,OFFSET DTA2	;POINT TO WHERE READ IN
	CALL	WIPE		;CALL ROUTINE TO WIPE-OUT THE CODE
	MOV	DX,OFFSET DTA1	;POINT TO DISK TRANSFER ADDRESS FOR IBMDOS.COM
	MOV	AH,SETDTA	;LOAD AH WITH SET DTA FUNCTION CODE
	DOS			;SET THE DISK TRANSFER ADDRESS
	MOV	BX,OFFSET IBMDOS;POINT TO FCB FOR IBMDOS.COM
	MOV	CX,DOSMAX	;LOAD CX WITH MAXIMUM RECORD COUNT (BYTES)
	CALL	READ		;CALL ROUTINE TO READ THE FILE
	MOV	BX,OFFSET IBMDOS;POINT TO FCB FOR IBMDOS.COM
	MOV	DX,OFFSET DTA1	;POINT TO WHERE IT WAS READ IN
	CALL	WIPE		;CALL ROUTINE TO WIPE-OUT THE CODE
	MOV	DX,OFFSET DTA2	;POINT TO DISK TRANSFER AREA FOR IBMBIO.COM
	MOV	AH,SETDTA	;LOAD AH WITH SET DTA FUNCTION CODE
	DOS			;SET THE DISK TRANSFER ADDRESS
	MOV	BX,OFFSET IBMBIO;POINT TO IBMBIO.COM FCB
	CALL	WRITE		;CALL ROUTINE TO WRITE THE FILE
	MOV	DX,OFFSET DTA1	;POINT TO DISK TRANSFER AREA FOR IBMDOS.COM
	MOV	AH,SETDTA	;LOAD AH WITH SET DTA FUNCTION CODE
	DOS			;SET THE DISK TRANSFER ADDRESS
	MOV	BX,OFFSET IBMDOS;POINT TO IBMDOS.COM FCB
	CALL	WRITE		;CALL ROUTINE TO WRITE THE FILE
	MOV	DX,OFFSET MSG4	;POINT TO SYSTEM ERASED MESSAGE
MSGRET	LABEL	NEAR		;PRINT MESSAGE AND RETURN TO DOS SECTION
	MOV	AH,PRINT	;LOAD AH WITH PRINT STRING FUNCTION CODE
	DOS			;PRINT THE MESSAGE
	EXIT			;RETURN CONTROL TO PC-DOS
UNDOS	ENDP			;END OF SYS PROCEDURE
WIPE	PROC	NEAR		;PROCEDURE TO WIPE-OUT DISK TRANSFER AREA
	MOV	CX,[BX].SAVE3	;GET THE NUMBER OF BYTES TO WIPE-OUT
	MOV	DI,DX		;GET OFFSET TO DISK TRANSFER AREA
	PUSH	DS		;SAVE A COPY OF DS ON THE STACK
	POP	ES		;PUT THE DS COPY INTO ES (POINT ES:DI TO DTA)
	XOR	AL,AL		;ZERO THE AL REGISTER
	REPZ	STOSB		;ZERO THE DISK TRANSFER AREA
	RET			;RETURN TO THE CALLER
WIPE	ENDP			;END OF THE WIPE PROCEDURE
READ	PROC	NEAR		;ROUTINE TO READ A FILE
	MOV	AH,RBLKRD	;LOAD AH WITH RANDOM BLOCK READ CODE
	MOV	DX,BX		;POINT DX TO FCB
	DOS			;READ THE BLOCK
	MOV	[BX].SAVE3,CX	;SAVE THE FILE SIZE (BYTES)
	MOV	AX,[BX].DATE	;GET DATE CREATED
	MOV	[BX].SAVE1,AX	;SAVE DATE CREATED
	MOV	AX,[BX].TIME	;GET TIME CREATED
	MOV	[BX].SAVE2,AX	;SAVE TIME CREATED
	RET			;RETURN TO THE CALLER
READ	ENDP			;END OR READ PROCEDURE
WRITE	PROC	NEAR		;ROUTINE TO WRITE THE FILE
	MOV	DX,BX		;MOVE FCB POINTER TO DX
	XOR	AX,AX		;ZERO AX REGISTER
	MOV	[BX].RREC1,AX	;SET LSB OF RELATIVE RECORD NUMBER TO ZERO
	MOV	[BX].RREC2,AX	;SET MSB OF RELATIVE RECORD NUMBER TO ZERO
	INC	AX		;INCREMENT AX TO ONE
	MOV	[BX].REC,AX	;SET RELATIVE RECORD SIZE TO ONE (BYTE)
	MOV	AH,RBLKWR	;LOAD AH WITH RANDOM BLOCK WRITE CODE
	MOV	CX,[BX].SAVE3	;GET RECORD COUNT (FILE SIZE IN BYTES)
	DOS			;WRITE THE FILE
	MOV	AX,[BX].SAVE1	;GET SAVED DATE CREATED (ORIGINAL)
	MOV	[BX].DATE,AX	;SAVE AS CURRENT DATE
	MOV	AX,[BX].SAVE2	;GET SAVED TIME CREATED (ORIGINAL)
	MOV	[BX].TIME,AX	;SAVE AS CURRENT TIME
	MOV	AH,CLOSE	;LOAD AH WITH CLOSE FILE CODE
	DOS			;CLOSE THE FILE
	RET			;RETURN TO THE CALLER
WRITE	ENDP			;END OF WRITE PROCEDURE
MSG1	EQU	THIS WORD	;MESSAGE NUMBER ONE
	DB	"Invalid drive specification$"
MSG2	EQU	THIS WORD	;MESSAGE NUMBER TWO
	DB	"Invalid parameter$"
MSG3	EQU	THIS WORD	;MESSAGE NUMBER THREE
	DB	"Insert system disk in drive "
DRIVE	EQU	THIS BYTE	;DRIVE NUMBER IN PRINT MESSAGE
	DB	"A"
	DW	CRLF
	DB	"and strike any key when ready"
	DW	CRLF
	DB	"$"
MSG4	EQU	THIS WORD	;MESSAGE NUMBER SIX
	DB	"System erased!$"
DEFAULT EQU	THIS BYTE	;SAVE AREA FOR CURRENT DEFAULT DRIVE NUMBER
	DB	0
IBMBIO	EXTFCB	<,,,,"IBMBIO","COM">
IBMDOS	EXTFCB	<,,,,"IBMDOS","COM">
CHK	EQU	THIS WORD/2*2
OFF	EQU	THIS WORD-CHK
DTA1	EQU	THIS WORD+1	;DISK TRANSFER AREA ONE (FILE IBMDOS)
DTA2	EQU	DTA1+DOSMAX	;DISK TRANSFER AREA TWO (FILE IBMBIO)
CODE	ENDS			;END OF CODE SEGMENT
	END	UNDOS		;END OF UNDOS COMMAND
