
M	EQU	Byte Ptr 0[BX]
;
;		CRCK.ASM version 3.0
;		 (revised 8/10/80)
;
;PROGRAM TO READ ANY CP/M FILE AND PRINT A
;CYCLIC-REDUNDANCY-CHECK NUMBER BASED ON THE
;CCITT STANDARD POLYNOMINAL:
;   X^16 + X^15 + X^13 + X^7 + X^4 + X^2 + X + 1
;
;USEFUL FOR CHECKING ACCURACY OF FILE TRANSFERS.
;MORE ACCURATE THAN A SIMPLE CHECKSUM.
;
;COMMANDS:   (drive name may be specified)
;	CRCK FILENAME.FILETYPE
;	CRCK *.ASM
;	CRCK *.*
;
;06/27/79 FIRST WRITTEN BY KEITH PETERSEN, W8SDZ
;
;08/19/79 ADD CONDITIONAL ASSEMBLY FOR CP/M
;	  ON H8 OR TRS-80.  (KBP)
;
;08/20/79 FIX BUG IN READIT ROUTINE WHICH
;	  SHOWED UP ONLY ON ALTCPM OPTION. (KBP)
;
;04/21/80 ADD MULTIPLE FILENAME FEATURE, PRINT
;	  NAME OF CURRENT FILE BEING READ, AND
;	  ALLOW OPERATOR ABORT. (KBP)
;
;04/23/80 CORRECT OMISSION OF SHR 8 IN MFA ROUTINE.
;	  ERROR ONLY SHOWED UP FOR ALTCPM ASSEMBLY
;	  ADD COLON AFTER ---> FILE:    (KBP)
;
;08/10/80 ADD ROUTINES TO ALLOW CONDITIONAL ASSEMBLY
;         OF WILDCARD ROUTINES AND TO ALLOW "SYSTEM"
;         FILES TO BE EXCLUDED FROM WILDCARD OPTION.
;         (BY DAVE HARDY)
;
TRUE	EQU	1
FALSE	EQU	0
;
;
STDCPM	EQU	TRUE			;TRUE IS STANDARD CP/M
ALTCPM	EQU	FALSE			;TRUE IS H8 OR TRS-80
WILDCD	EQU	TRUE			;WANT WILDCARDS IN FILENAME?
SYSFILE	EQU	FALSE			;WANT SYS FILES IN WILDCARDS?
;
BASE	EQU	0
;
;
CR	EQU	0DH
LF	EQU	0AH
TAB	EQU	09H
;
	ORG	BASE+100H
;
	JMPS	BEGIN			;JUMP AROUND IDENTIFICATION
L_1	EQU	$
	DSEG
	ORG	Offset L_1
	DB	'CRCK ver 3.0 8/3/80 '
L_2	EQU	$
	CSEG
	ORG	Offset L_2
;
BEGIN:	MOV	BX,0			;GET STACK...
	LAHF				;POINTER SO WE CAN...
	ADD	BX,SP
	RCR	SI,1
	SAHF
	RCL	SI,1
	MOV	Word Ptr STACK,BX	;SAVE IT
	MOV	SP,(Offset STACK)	;INITIALIZE LOCAL STACK
	CALL	START
	DB	'CRCK ver 3.0'
	DB	CR,LF,CR,LF,'$'
;
START:	POP	DX			;GET ID
	MOV	CL,PRINT
	INT	224			;PRINT ID
;
AGAIN:	CALL	MFNAME			;SEE IF FILE NAME TO READ
	JB	AGEND
	MOV	AL,Byte Ptr .FCB+10	;GET SYS ATTRIBUTE
	AND	AL,80H
	JNZ	AGAIN			;IGNORE IF SYSTEM FILE
	JNB	NAMEPR			;YES, GO READ IT
AGEND:	CALL	MSGEXIT			;NONE, PRINT MSG THEN EXIT
	DB	'DONE$'
;
NAMEPR:				;PRINT FILENAME.TYPE
;MOVE 8 CHARACTERS FROM FCB+1 TO FNAME
	MOV	BX,FCB+1
	MOV	DX,(Offset FNAME)
	MOV	CX,8
	CALL	MOVER
;MOVE 3 CHARACTERS FROM FCB+9 TO FNAME+9
	MOV	BX,FCB+9
	MOV	DX,(Offset FNAME)+9
	MOV	CX,3
	CALL	MOVER
	CALL	NAMEP2
	DB	'--> FILE:  '
FNAME	DB	'XXXXXXXX.XXX',TAB,TAB,'CRC = $'
;
NAMEP2:	POP	DX			;GET ADRS OF STRING
	MOV	CL,PRINT
	INT	224			;PRINT FILENAME.TYPE
;
;OPEN THE FILE
	MOV	DX,FCB
	MOV	CL,OPEN
	INT	224
	INC	AL
	JNZ	INITIT
	CALL	ERXIT
	DB	CR,LF,'++OPEN FAILED++$'
;
;INITIALIZE THINGS
INITIT:	MOV	BX,0
	MOV	Word Ptr REM,BX		;INIT CRC REMAINDER TO ZERO
	MOV	BX,BASE+100H
	MOV	Word Ptr BUFAD,BX	;FORCE INITIAL READ
;
READIT:	MOV	BX,Word Ptr BUFAD
	MOV	AL,BH			;TIME TO READ?
	CMP	AL,BASE SHR 8
	JZ	NORD			;NO READ
	MOV	CL,CONST
	INT	224			;CHECK FOR OPERATOR ABORT
	OR	AL,AL
	JZ	READ2			;NOTHING FROM OPERATOR
	MOV	CL,RDCON
	INT	224			;GET CHARACTER INPUTTED
	CMP	AL,'C'-40H		;CONTROL C?
	JNZ	L_3	
	JMP	EXIT			;YES EXIT
L_3:
;
READ2:	MOV	DX,FCB
	MOV	CL,READ
	INT	224
	OR	AL,AL
	JNZ	FINISH			;ERROR OR EOF
	MOV	BX,BASE+80H		;BUFFER LOCATION
NORD:	MOV	AL,M
	MOV	Byte Ptr MESS,AL	;SAVE FOR DIVP
	INC	BX
	MOV	Word Ptr BUFAD,BX
	CALL	DIVP
	JMPS	READIT
;
FINISH:	MOV	AL,Byte Ptr REM+1	;GET MSP OF CRC
	CALL	HEXO			;PRINT IT
	MOV	AL,' '
	CALL	TYPE			;TYPE A SPACE
	MOV	AL,Byte Ptr REM		;GET LSP OF CRC
	CALL	HEXO			;PRINT IT
	MOV	DX,(Offset NEWLIN)	;POINT TO CRLF
	MOV	CL,PRINT
	INT	224			;PRINT IT
	JMP	AGAIN			;SEE IF MORE FILES TO DO
;
NEWLIN	DB	CR,LF,CR,LF,'$'
;
;---------------------------------------------
;AN 8080 ROUTINE FOR GENERATING A CYCLIC-
;REDUNDANCY-CHECK.  CHARACTER LEAVES THAT
;CHARACTER IN LOCATION REM.  BY FRED GUTMAN.
;FROM 'EDN' MAGAZINE, JUNE 5, 1979 ISSUE, P84.
;
DIVP:	MOV	BX,Word Ptr REM		;GET REMAINDER
	MOV	AL,BH
	AND	AL,128			;Q-BIT MASK
	LAHF				;SAVE STATUS
	XCHG	AL,AH
	PUSH	AX
	SHL	BX,1			;2 X R(X)
	MOV	AL,Byte Ptr MESS	;MESSAGE BIT IN LSB
	ADD	AL,BL
	MOV	BL,AL
	POP	AX
	XCHG	AL,AH
	SAHF
	JZ	QB2			;IF Q-BIT IS ZERO
QB:	MOV	AL,BH
	XOR	AL,0A0H			;MS HALF OF GEN. POLY
	MOV	BH,AL
	MOV	AL,BL
	XOR	AL,97H			;LS HALF OF GEN. POLY
	MOV	BL,AL
QB2:	MOV	Word Ptr REM,BX
	RET
;--------------------------------------------
;
;HEX OUTPUT
;
HEXO:	LAHF				;SAVE FOR RIGHT DIGIT
	XCHG	AL,AH
	PUSH	AX
	XCHG	AL,AH
	RCR	AL,1			;RIGHT..
	RCR	AL,1			;..JUSTIFY..
	RCR	AL,1			;..LEFT..
	RCR	AL,1			;..DIGIT..
	CALL	NIBBL			;PRINT LEFT DIGIT
	POP	AX			;RESTORE RIGHT
	XCHG	AL,AH
NIBBL:	AND	AL,0FH			;ISOLATE DIGIT
	CMP	AL,10			;IS IS <10?
	JB	ISNUM			;YES, NOT ALPHA
	ADD	AL,7			;ADD ALPHA BIAS
ISNUM:	ADD	AL,'0'			;MAKE PRINTABLE
;
TYPE:	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	DL,AL
	MOV	CL,WRCON
	INT	224
	POP	BX
	POP	DX
	POP	CX
	RET
;
;
;	MFA.LIB		(revised 4/23/80)
;
;MULTI-FILE ACCESS SUBROUTINE.  ALLOWS PROCESSING
;OF MULTIPLE FILES (I.E. *.ASM) FROM DISK.  THIS
;ROUTINE BUILDS THE PROPER NAME IN THE FCB EACH
;TIME IT IS CALLED.  JUST CALL "MFNAME" (MULTIPLE
;FILE NAME) AND THE FCB WILL BE SET UP WITH THE NEXT
;NAME, READY TO DO NORMAL PROCESSING (OPEN, READ, ETC.)
;
;CARRY IS SET IF NO MORE NAMES CAN BE FOUND
;
;------------------------------------------------
;
;	MULTI-FILE ACCESS SUBROUTINE
;
;THE ROUTINE IS COMMENTED IN PSEUDO CODE,
;EACH PSEUDO CODE STATEMENT IS IN <<...>>
;
MFNAME:				;<<INIT DMA ADDR, FCB>>
	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	CL,STDMA
	MOV	DX,BASE+80H
	INT	224
	POP	BX
	POP	DX
	POP	CX
	XOR	AL,AL
	MOV	Byte Ptr .FCBEXT,AL
	MOV	Byte Ptr .FCBRNO,AL
;<<IF FIRST TIME>>
	MOV	AL,Byte Ptr MFFLG1
	OR	AL,AL
	JNZ	MFN01
;<<TURN OFF 1ST TIME SW>>
	MOV	AL,1
	MOV	Byte Ptr MFFLG1,AL
;<<SAVE THE REQUESTED NAME>>
;SAVE ORIG REQ
	MOV	BX,FCB
	MOV	DX,(Offset MFREQ)
	MOV	CX,12
	CALL	MOVER
	MOV	AL,Byte Ptr .FCB
	MOV	Byte Ptr MFCUR,AL	;SAVE DISK IN CURR FCB
;<<SRCHF REQ NAME>>
	MOV	BX,(Offset MFREQ)
	MOV	DX,FCB
	MOV	CX,12
	CALL	MOVER
	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	CL,SRCHF
	MOV	DX,FCB
	INT	224
	POP	BX
	POP	DX
	POP	CX
;<<ELSE>>
	JMPS	MFN02
;
MFN01:					;<<SRCHF CURR NAME>>
	MOV	BX,(Offset MFCUR)
	MOV	DX,FCB
	MOV	CX,12
	CALL	MOVER
	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	CL,SRCHF
	MOV	DX,FCB
	INT	224
	POP	BX
	POP	DX
	POP	CX
;<<SRCHN REQ NAME>>
	MOV	BX,(Offset MFREQ)
	MOV	DX,FCB
	MOV	CX,12
	CALL	MOVER
	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	CL,SRCHN
	MOV	DX,FCB
	INT	224
	POP	BX
	POP	DX
	POP	CX
;<<ENDIF>>
MFN02:					;<<RETURN CARRY IF NOT FOUND>>
	INC	AL
	STC
	JNZ	L_4
	RET
L_4:
;<<MOVE NAME FOUND TO CURR>>
	DEC	AL
	AND	AL,3
	ADD	AL,AL
	ADD	AL,AL
	ADD	AL,AL
	ADD	AL,AL
	ADD	AL,AL
	ADD	AL,81H
	MOV	BL,AL
	MOV	BH,BASE SHR 8
	PUSH	BX			;SAVE NAME POINTER
	MOV	DX,(Offset MFCUR)+1
	MOV	CX,11
	CALL	MOVER
;<<MOVE NAME FOUND TO FCB>>
	POP	BX
	MOV	DX,FCB+1
	MOV	CX,11
	CALL	MOVER
;<<SETUP FCB>>
	XOR	AL,AL
	MOV	Byte Ptr .FCBEXT,AL
	MOV	Byte Ptr .FCBRNO,AL
;<<RETURN>>
	RET
;
;MOVE SUBROUTINE
;
MOVER:	MOV	AL,M
	MOV	SI,DX
	MOV	[SI],AL
	INC	BX
	INC	DX
	DEC	CX
	MOV	AL,CH
	OR	AL,CL
	JNZ	MOVER
	RET
;
;------------------------------------------
;
;EXIT WITH MESSAGE
;
MSGEXIT	EQU	(Offset $)		;EXIT W/"INFORMATIONAL" MSG
ERXIT:	POP	DX			;GET MSG
	MOV	CL,PRINT
	INT	224
;
;EXIT, RESTORING STACK AND RETURN
;
EXIT:	MOV	BX,Word Ptr STACK
	MOV	SP,BX
	RET				;TO CCP
L_5	EQU	$
	DSEG
	ORG	Offset L_5
;
REM	DW	0			;REMAINDER STORAGE
BUFAD	RS	2			;BUFFER ADDRESS
MESS	RS	1			;MESSAGE CHAR GOES HERE
;
;MULTI-FILE ACCESS WORK AREA
;
MFFLG1	DB	0			;1ST TIME SW
MFREQ	RS	12			;REQ NAME
MFCUR	RS	12			;CURR NAME
;
	RS	64			;STACK AREA
STACK	RS	2
;
;BDOS/CBIOS EQUATES
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CONST	EQU	11
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
REN	EQU	23
STDMA	EQU	26
BDOS	EQU	BASE+5
FCB	EQU	BASE+5CH
FCB2	EQU	BASE+6CH
FCBEXT	EQU	FCB+12
FCBRNO	EQU	FCB+32
;
	END
