;^^^^^^^^^^^^^^^^^^^^^^^8086 Assembler MACROS^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;       By Mark Stout, Compaq Computer
;==============================================================================
;
;       DISPLAY Macro:
;
;       Displays string of characters on standard output.  String must be
;       terminated by '$'.
;
;       Format:
;
;               DISPLAY message
;
;       where message is the offset of the string.
;
;==============================================================================

DISPLAY   MACRO    MESSAGE

        PUSH    DX
        PUSH    AX

        LEA     DX, MESSAGE             ;Point to offset of string
        MOV     AH, 9H                  ;Use DOS function 9H
        INT     21H

        POP     AX
        POP     DX

ENDM

;==============================================================================
;
;       INPUT Macro:
;
;       Reads string of characters from standard input.
;
;       Format:
;
;       INPUT buffer
;
;       where buffer is the offset of an input buffer with this format:
;
;               First byte:  Maximum number of characters desired, including
;                            terminating CR.
;
;               Second Byte: Storage for actual number of characters read,
;                            returned by macro.
;
;               Third Byte:  Start of buffer for characters read.
;
;==============================================================================

INPUT   MACRO   BUFFER

        PUSH    AX
        PUSH    DX

        LEA     DX, BUFFER              ;Point to start of input buffer
        MOV     AH, 0AH                 ;Use DOS function Ah
        INT     21H

        POP     DX
        POP     AX

ENDM

;==============================================================================
;
;       BIN2ASCII Macro:
;
;       Converts binary value in DX to ASCII string.
;
;       Format:
;
;               BIN2ASCII length, out_buffer
;
;       where length is the # of characters for the output string, including
;       leading spaces, and out_buffer is location of output buffer.
;
;==============================================================================

BIN2ASCII  MACRO  LENGTH, OUT_BUFFER
        LOCAL   ASCIILOOP, BLANK, NEXT, PAD  ;Define local labels for multiple invocations

        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    DI

        MOV     CX, LENGTH              ;Set up CX as counter of ASCII digits
        MOV     AX, DX                  ;Move binary value to accumulator
        MOV     BX, 10                  ;Set up BX as decimal base

ASCIILOOP:
        MOV     DI, CX                  ;Use DI for index relative addressing of ASCII string
        CMP     AX, 0                   ;If accumulator = 0, pad left of string with blanks
        JE      BLANK
        MOV     DX, 0                   ;Prepare DX as high word of dividend
        DIV     BX                      ;Divide remaining value by decimal base
        ADD     DX, 30H                 ;Convert remainder to ASCII for use in string
        MOV     [OUT_BUFFER+DI-1], DL   ;Converted remainder is next least significant digit in string
        JMP     NEXT

BLANK:  CMP     CX, LENGTH              ;Checks for binary value = 0
        JNE     PAD
        MOV     [OUT_BUFFER+DI-1], '0'
        JMP     NEXT

PAD:    MOV     [OUT_BUFFER+DI-1], ' '  ;Pads left of string with blanks when necessary
NEXT:   LOOP    ASCIILOOP               ;Calculate next digit of string

        POP     DI
        POP     DX
        POP     CX
        POP     BX
        POP     AX

ENDM

;==============================================================================
;
;       PRINT Macro:
;
;       Prints ASCII string of characters, terminated by '$'.
;
;       Format:
;
;               PRINT   print_output
;
;       where print_output is the offset of the string.
;
;==============================================================================

PRINT   MACRO   PRT_OUTPUT
        LOCAL PRINT_DIGIT, END_O_STRING ;Define local labels for multiple invocation

        PUSH    DX
        PUSH    SI
        PUSH    AX

        MOV     SI, 1                   ;Initialize SI for memory addressing of characters to be printed
        MOV     AH, 5                   ;Ready AH for DOS Function Call #5

PRINT_DIGIT:
        MOV     DL, [PRT_OUTPUT+SI-1]   ;Load character from string into DL
        CMP     DL, '$'                 ;If character = $, terminate print
        JE      END_O_STRING
        INT     21H                     ;DOS Function Call #5
        INC     SI                      ;Ready index for next character
        JMP     PRINT_DIGIT

END_O_STRING:
        POP     AX
        POP     SI
        POP     DX

ENDM

;==============================================================================
;
;       ASCII2BIN Macro:
;
;       Converts a decimal, ASCII string to a binary value.  Works for numbers
;       less than 65,535.  Inputs over this range cause invalid results,
;       indicated by AX = FFFFh after invocation.
;
;       Format:
;
;               ASCII2BIN ascii_string
;
;       where ascii_string is the offset of the ASCII string.
;
;       Input:  AX = Number of ASCII digits in string.
;
;       Output: AX = Binary value of number.
;
;==============================================================================

ASCII2BIN   MACRO  ASCII_STRING
        LOCAL   DIGIT_LOOP, OKAY

        PUSH    CX
        PUSH    DX
        PUSH    BX
        PUSH    SI

        MOV     CX, AX                  ;Set up conversion loop counter
        MOV     SI, 0                   ;Initialize digit index
        MOV     AX, 0                   ;Initialize sum at 0
        MOV     BX, 10                  ;Use BX as decimal base

DIGIT_LOOP:
        MUL     BX                      ;Multiply accumulator by decimal base
        ADD     AL, ASCII_STRING[SI]    ;Add next digit from ASCII string
        ADC     AH, 0                   ;Complete addition through high byte of AX
        SUB     AX, 30H                 ;Convert ASCII addition to binary value
        INC     SI                      ;Increment ASCII digit index
        LOOP    DIGIT_LOOP              ;Repeat for next digit

        CMP     DX, 0                   ;If DX not = 0, result will be invalid
        JE      OKAY
        MOV     AX, 0FFFFH              ;Flag invalid results

OKAY:
        POP     SI
        POP     BX
        POP     DX
        POP     CX

ENDM

;===============================================================================
;
;       SCROLL_UP Macro:
;
;       Uses BIOS function INT 10h, Subfunction 6, to scroll a pre-defined
;       window a given number of lines. New lines are white foreground on
;       black background.
;
;       Format:
;
;       SCROLL_UP  lines, TL_row, TL_col, BR_row, BR_col
;
;       where:  lines  = # of lines to scroll (0 for entire window)
;               TL_row = row of top, left corner
;               TL_col = column of top, left corner
;               BR_row = row of bottom, right corner
;               BR_col = column of bottom, right corner
;
;===============================================================================

SCROLL_UP       MACRO   LINES, TL_ROW, TL_COL, BR_ROW, BR_COL

        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX

        MOV     AH, 6
        MOV     AL, LINES
        MOV     CH, TL_ROW
        MOV     CL, TL_COL
        MOV     DH, BR_ROW
        MOV     DL, BR_COL
        MOV     BH, 7

        INT     10H

        POP     DX
        POP     CX
        POP     BX
        POP     AX

ENDM

;===============================================================================
;
;       LOCATE Macro:
;
;       Uses BIOS function INT 10h, Subfunction 2, to position cursor.
;
;       Input:  DH = Row coordinate (0-24)
;               DL = Column coordinate (0-79)
;
;===============================================================================

LOCATE  MACRO

        PUSH    AX
        PUSH    BX

        MOV     AH, 2
        MOV     BH, 0
        INT     10H

        POP     BX
        POP     AX

ENDM

;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
