;  SYSPARM.ASM - DKeels						     07/09/84
;----------------------------------------------------------------------------
;  This is a resident system process (RSP) which is to be loaded into memory 
;  at boot time.  
;  The program consists of two parts:  
;  1) An initialization routine sets up the interrupt mechanism and 
;  sets aside an area of memory which can be used for parameter passing 
;  between programs.  This memory is preserved upon exit (it becomes 
;  resident).
;  2) The interrupt mechanism, which remains resident, simply returns the
;  segment address of the parameter table in AX.
;----------------------------------------------------------------------------
PAGE 66,132

;NOTE:  The following equate is used to determine the size of the memory
;	block (in paragraphs) to leave resident.  It has been padded somewhat 
;	to absorb minor changes in the length of this program, and to 
;	compensate for some appearant bugs in DOS.  If the length
;	should change substantially, (eg, expanding PARM_AREA by 16 bytes), 
;	then add enough paragraphs to SYSPARM_LENGTH to compensate.

SYSPARM_LENGTH	EQU	0110H


ABSOLUTE_0	SEGMENT	AT 0
		ORG	4*77H
INTERRUPT_77H	DD				;interrupt 77H vector
ABSOLUTE_0	ENDS


STACK_SEG	SEGMENT STACK 'STACK'
		DB	2 DUP('dkstack ')	;stack space
STACK_SEG	ENDS


CODE		SEGMENT
		ASSUME CS:CODE,DS:CODE,ES:CODE
ENTRY_POINT:	JMP	INITIALIZE		;jump to initialization routine

ORIGINAL_VECTOR	DD	?			;save original int 77h vector
SYSPARM_ID_TAG	DB	'PMS/dlk'		;used to prevent reloading
		DB	2 DUP(0)		;put load_table on para boundry

LOAD_TABLE	EQU	$			;LOADer parameter area
FILE_SPEC_1	DB	80 DUP(' ')		;+0
		DB	0			;+80
PARAMETER_1_LEN DB	0			;+81
PARAMETER_1	DB	80 DUP(' ')		;+82
		DB	13			;+162
FILE_SPEC_2	DB	80 DUP(' ')		;+163
		DB	0			;+243
PARAMETER_2_LEN DB	0			;+244
PARAMETER_2	DB	80 DUP(' ')		;+245
		DB	13			;+325

COLOR_TABLE	EQU	$
FOREGROUND	DW	07			;+326
BACKGROUND	DW	00			;+328
BORDER		DW	00			;+330
EMPHASIZED_FGD	DW	15			;+332
WINDOW_FGD	DW	00			;+334
WINDOW_BGD	DW	07			;+336

TABLE_SIZE	DW	3600			;(+338) current max. table size
MAX_ENTRIES	DW	3600/18			;(+340) current table entries

TABLE		DB	3600 DUP(' ')		;cross-reference table
PARM_AREA	DB	10 DUP(' ')		;unused parameter area

;CAUTION: Changing data configurations before this point could be dangerous!
;The size of the PARM_AREA can be expanded to 64K, but the SYSPARM_LENGTH
;(above) must be changed accordingly.

;----------------------------------------------------------------------------
; This is the code to process the interrupts, once resident.  The 
; initialization routine points the interrupt vector to this routine.
;----------------------------------------------------------------------------
INTERRUPT_CODE	PROC	FAR
		ASSUME CS:CODE,DS:NOTHING,ES:NOTHING

		CMP	DX,'dk'			;verify interrupt
		JE	CONTINUE		;if DX='dk', then do sysparm
		JMP	ORIGINAL_VECTOR		;else not a call to sysparm

CONTINUE:	MOV	AX,CS			;segment address
		INC	AX			;plus offset (1 paragraph)
		IRET

INTERRUPT_CODE	ENDP

;INTERRUPT_END	DB	?			;mark end of resident code

;************************* END OF RESIDENT CODE *****************************


;----------------------------------------------------------------------------
; Initialization routine saves original value of int 77h vector, then
; replaces vector with address of SYSPARM interrupt handler code.  This
; routine terminates and leaves the interrupt code and parm table resident.
;----------------------------------------------------------------------------

SYSPARM_LOAD	PROC	FAR
INITIALIZE:
		CLI				;no interruptions, please
		PUSH	DS			;establish far return to DOS
		SUB	AX,AX
		PUSH	AX
		MOV	ES,AX			;ES -> 0000:xxxx
		ASSUME	ES:ABSOLUTE_0
		MOV	AX,WORD PTR ES:INTERRUPT_77H	;get original vector
		MOV	BX,WORD PTR ES:INTERRUPT_77H+2
		MOV	WORD PTR DS:ORIGINAL_VECTOR,AX	;save in code segment
		MOV	WORD PTR DS:ORIGINAL_VECTOR+2,BX

	;prevent reloading sysparm
		MOV	ES,BX			;ES -> seg of current int vect
		LEA	DI,DS:SYSPARM_ID_TAG	;DI -> offset to tag
		PUSH	CS
		POP	DS			;DS -> code segment
		MOV	SI,DI			;SI -> offset to tag
		MOV	CX,7			;length of tag
		CLD
		REPE	CMPSB			;DS:BYTE PTR [SI],ES:[DI]
						;if sysparm tag is present
		JZ	EARLY_EXIT		;then do not reload

	;set new vector
		MOV	AX,0			;re-address absolute 0
		MOV	ES,AX
		MOV	WORD PTR ES:INTERRUPT_77H,OFFSET INTERRUPT_CODE
		MOV	WORD PTR ES:INTERRUPT_77H+2,CS

		STI				;interrupts ok now

;		LEA	DX,CS:INTERRUPT_END	;point to end of intrpt code
;		MOV	CL,4			;convert bytes to paragraphs
;		SHR	DX,CL
;		INC	DX			;round up
		MOV	DX,SYSPARM_LENGTH	;this works better
		SUB	AL,AL
		MOV	AH,31H
		INT	21H			;exit and stay resident

	;exit if SYSPARM has already been loaded.
EARLY_EXIT:
		RET				;return to DOS		

SYSPARM_LOAD	ENDP


CODE		ENDS
		END	ENTRY_POINT		;point IP to first instruction
