	page 58,132
	title
	name 

comment	*

	This code will parse an command line and place all command line
	arguments onto the stack and build "argc" and an "argv" array to
	allow access to these arguments.
	
	6 Jan 85				Raymond Moon
	
	*
	
	.xlist
	include \MASM\EQUATES.H			; Include Equates header file
	.list
	
	if1
	include \MASM\MACRO.H			; Include Macro header file
	endif

GRP	group	CSEG,DSEG			; All segments in same segment
	assume	cs:GRP,ds:GRP,es:GRP,ss:GRP
	
	subttl Data Segments
	page

	subttl  Code Segment
	page
CSEG	segment para public 'CODE'

;----------------------------  
;	Define external procedures

	extrn CLS:near,ISDOS2:near

;-----------------------------
;	Define all procedures as public for debugging

	public MAIN

;-----------------------------
;	Define Command Line arguments located in the PSP

	org     80h
	PARM_LEN db     ?
	PARMS   db      127 dup(?)

;-----------------------------
;	MAIN procedure parses the Command Line 

	org	100h			; .COM file format
MAIN	proc	far
	push	pDOS_ERR		; Pass addr of DOS_ERR
	call	ISDOS2			; Check to see if DOS is 2.0+ 
	add	sp,2			; Reset SP
	cmp	PARM_LEN,0		; Are there any Command Line arguments
	jne	MN1			; Yes, process them
	call	MENU			; No, go to Menu 
MN1:	xor	cx,cx			; Null CX
	push	cx			; This ensures last *argv ends in NUL
	mov	cl,PARM_LEN		; Get # of bytes in Command Line
	inc	cl			; Increment CL to ensure round up
	and	cx,0feh			; Force an even count
	mov	ax,sp			; Get SP  
	mov	bp,sp			; Set BP to last byte of Cmd Ln
	sub	ax,cx			; Subtract PARM_LEN
	mov	sp,ax			; Reset SP, room on Stack
	lea	si,PARMS		; Load source addr in SI
	mov	di,sp			; Load destin addr in DI
	cld				; Ensure Direction Flag is up
	rep	movsb			; Move Command Line onto the Stack

;-----------------------------
;	Convert all blanks in the Command Line to Nul

	mov	bx,bp			; BX points to last byte of Cmd Ln
MN2:	mov	al,[bx]			; Get byte
	cmp	al,BLNK			; Is it a blank?
	ja	MN3			; No, go set up to get another
	xor	al,al			; Nul AX
	mov	[bx],al			; Store Nul in [BX]
MN3:	dec	bx			; BX point to next byte
	cmp	bx,sp			; Are we through yet?
	jnb	MN2			; No, go one mo' 'gin
                    
;-----------------------------
;	Build *argv[].  argc kept in CX.  DX used as IN_WORD flag

	xor	cx,cx			; Set CX (argc) to 0
	xor	dx,dx			; Set DX to NOT_INWORD
	mov	bx,bp			; BX point to last byte
	mov	bp,sp			; BP now points to Top of Stack
MN4:	mov	al,[bx]			; Get byte
	cmp	al,0			; Is it Nul?
	jne	MN5			; No, it is a char
	cmp	dx,0			; Was the last byte not a char?
	je	MN6			; Yes, go on with the processing
	xor	dx,dx			; No, it was a char.  Clear INWORD.
	inc	cx			; Increment argc
	inc	bx			; BX points to Cmd Ln arg
	push	bx			; Push addr onto stack
	dec	bx			; Reset BX
	jmp	short MN6		; Go set up for another byte
MN5:	inc	dx			; Set DX to INWORD     
MN6:	dec	bx			; BX point to next byte
	cmp	bx,bp			; Are we at the 1st byte yet?
	jnb	MN4			; No, go process another

;-----------------------------
;	Set up for and call ?

	push	cx			; Push ARGC onto stack
	call	CMDLN			; Call Cmd Ln processor
MAIN	endp
	