/*	FILE:	TERM

	Program to set all the settable features of the async deivce
	driver on an MSDOS system.
;   (c) Copyright 1984 by The Computer Entomologist
;
;	Permission is hearby granted to use or distribute this software
;without any restrictions.  You may make copies for yourself or your
;friends. You may include it in any hardware or software product that you
;sell for profit.
;
;	This software is distributed as is, and is not guaranteed to work
;on any particular hardware/software configuration.  Furthermore, no 
;liability is granted with this software: the user takes responcibility for
;any damage this software may do to his system.
;
;	Nasy notices aside, if you have any questions about this software, you
;can reach me at the address below.  If you impliment any new features or
;find (and fix!) any bugs, I would be happy to hear from you.
;
;	Mike Higgins
;	The Computer Entomologist
;	P.O. Box 197
;	Duncans Mills, CA 95430

	**WARNING****
	Not all of the features below are implimented yet in the driver
	itself.  Do not expect them to work unless you see the code in
	the driver first.  In particular, input data throttling and
	output tab conversions are not implimented yet.
*/
char	*innam[]={"dtr is input data throttle signal\n",
	"rts is input data throttle signal\n",
	"inxon -- xon/xoff is used to throttle input data\n",
	"bell is echoed on input buffer full\n",
	"half duplex -- input chars are echoed when read\n",
	"flush sequence is recognized (control-x)\n",
	"redraw sequence is recognized (control-r)\n",
	"delete line sequence is recognized (control-u)\n",
	"skip output sequence is recognized (contril-o)\n",
	"errstat -- line errors produce MSDOS error status returns\n",
	"errcodes -- line errors return codes with parity bit on\n",
	"strip parity on input characters\n",
	"upper case all input characters\n",
	"control-c passes through input buffer on non-destructive read\n",
	"reboot sequence is recognized (control-c control-r control-b\n",0};
int	inval[]={2,4,8,0x10,0x20,0x40,0x80,
		0x100,0x200,0x400,0x800,0x1000,0x2000,
		0x4000,0x8000,0};
char	*outnam[]={"dsr is output data throttle signal\n",
	"cts is output data throttle signal\n",
	"xonxoff throttles output data\n",
	"offcts -- cts is ofline signal\n",
	"offcd -- carrier detect is offline signal\n",
	"offdsr -- dsr is offline signal\n",
	"outstrip -- strip parity on all output characters\n",
	"outupper -- convert output chars to upper case\n",
	"tabs are converted to spaces on output\n",0};
int	outval[]={2,4,8,0x10,0x20,0x40,0x1000,0x2000,0x4000,0};
char	defname[]="ASYNC1";
struct	asy_tab		/*structure of the return from the ioctl to async*/
{
	char	lctrl;		/*line control byte*/
	char	mctrl;		/*modem control*/
	char	lstat;		/*line status*/
	char	mstat;		/*modem status*/
	int	inspec;		/*input special processing bits*/
	int	outspec;	/*output special processing bits*/
	int	baud;		/*baud rate*/
}	buf;
int	i,j,l;		/*pointers and loop counters*/
int	change=0;	/*flag set to 1 if any bits are changed*/
int	flag=0;		/*flag set to 1 if option is recognized*/
int	nope=0;		/*flag set to 1 if option is negated*/

char	*dev=defname;	/*pointer to device name*/
char	*ptr;		/*general pointer to strings*/

main(argc,argv)
int	argc;
char	*argv[];
{
    int	baud=0;
    int	setin=0;	/*bits to set in input mask*/
    int	clrin=0;	/*bits to clear in input mask*/
    int	setout=0;	/*bits to set in output mask*/
    int	clrout=0;	/*bits to clear in output mask*/
    j=0;
    i=0;

    while(++i < argc)		/*for all input arguments,*/
    {
	nope=0;
	flag=0;		/*initialize flags*/

	dolower(argv[i]);	/*convert them to upper case*/
	l=strlen(argv[i]);

	if (argv[i][l-1] == ':')	/*is this a device name?*/
	{
	    dev=argv[i];	/*then remember it's address*/
	    dev[l-1]=0;		/*and get rid of that colon!*/
	    flag=1;		/*mark this as a legal command*/
	}

	if (strncmp(argv[i],"spe",3) == 0)	/*is this a baud change?*/
	{
	    ptr=argv[i];
	    while (*ptr != 0)		/*scan forward looking for =*/
	    {
	    	if (*ptr++ == '=')
	    	{
		    if (sscanf(ptr,"%d",&baud) == 1)
		    {
			change=1;	/*set flag forcing ioctlwrite*/
			flag=1;		/*flag this as legal command*/
			buf.baud=baud;	/*store the new baud rate*/
		    }
		    break;
		}
	    }
	}

	if (strncmp(argv[i],"help",l) == 0)	/*asking for help?*/
	{
	    printf("This command accepts many options to control the\n");
	    printf("behavior of the ASYNC drivers.\n");
	    printf("Any option terminated with : is assumed to be the\n");
	    printf("name of the ASYNC drive to operate on. ASYNC1: is default.\n");
	    printf("The option SPEED=nnn will set the baud rate of the driver\n");
	    printf("to nnn.  Illegal baud rates are ignored.\n");
	    printf("All the following ASYNC driver options can be set by\n");
	    printf("typing the first few letters of the option.  To turn\n");
	    printf("an option off, prefix it with NO.\n");
	    j=0;		/*loop for all the output names*/
	    while (outnam[j] != 0)
		printf(outnam[j++]);
	    j=0;		/*loop for all the input names*/
	    while (innam[j] != 0)
		printf(innam[j++]);
	    flag=1;	/*mark this a legal flag*/
	}
	if (strncmp(argv[i],"no",2) == 0)	/*is this a negation?*/
	{
		argv[i] += 2;			/*skip over the "no"*/
		l -= 2;				/*take "no" off the length*/
		nope=1;				/*set flag*/
	}

	if (flag == 0)
	{
	    j=0;		/*loop for all the input names*/
	    while (innam[j] != 0)
	    {
		if (strncmp(argv[i],innam[j],l) == 0)
		{
		    flag=1;	/*recognise this command*/
		    if (nope == 0)
			setin |= inval[j];	/*set this bit*/
		    else
			clrin |= inval[j];	/*or clear it*/
		    change=1;			/*set the changed bit*/
		    break;
		}
		j += 1;
	    }
	}

	if (flag == 0)
	{
	    j=0;		/*loop for all the output names*/
	    while (outnam[j] != 0)
	    {
		if (strncmp(argv[i],outnam[j],l) == 0)
		{
		    flag=1;	/*i recognise this command,*/
		    if (nope == 0)	/*so set the bit that this option*/
			setout |= outval[j];	/*corresponds to*/
		    else
			clrout |= outval[j];	/*or clear it*/
		    change=1;
		    break;
		}
		j += 1;
	    }
	}
	if (flag == 0)		/*did anybody clame this command?*/
	    printf("Illegal option: %s\n",argv[i]);

    }

    ioctl(dev,&buf,10,2);	/*call the assembly ioctl for read*/

    if (change != 0)		/*were you changing any of the options?*/
    {
	if (baud != 0)
	    buf.baud=baud;
	buf.inspec |= setin;	/*set any requested bits*/
	buf.outspec |= setout;
	buf.inspec &= ~clrin;	/*clear any requested bits*/
	buf.outspec &= ~clrout;
	ioctl(dev,&buf,10,3);	/*request the ioctl write*/
	ioctl(dev,&buf,10,2);	/*and read it back to doublecheck*/
    }
    printf("status of device %s:	Baud rate: %d\n",dev,buf.baud);
/*    printf("Line control: %x	Modem control: %x\n",buf.lctrl,buf.mctrl);
    printf("Line status:  %x	Modem status:  %x\n",buf.lstat,buf.mstat);
*/
    printf("	>>>>Special treatment on input:\n");
    outstr(buf.inspec,inval,innam);	/*print all the input bits*/
    printf("	>>>>Special treatment on output:\n");
    outstr(buf.outspec,outval,outnam);	/*dito for all the output bits*/
    exit(1);
}
/*subroutine to print all the strings who's bits are set*/
outstr(bits,vals,nams)
int	bits;		/*mask with bits set in it*/
int	vals[];		/*array of bit values*/
char	*nams[];	/*array of pointers to bit name strings*/
{
	
    i=0;		/*initialize index to array*/
    while (vals[i] != 0)
    {
	if ((vals[i] & bits) != 0)	/*is this bit set?*/
	    printf(nams[i]);		/*yes, print the string*/
	i++;
    }
    return;
}
/*subroutine to lowercase a string*/
dolower(str)
char	*str;
{
    while(*str != 0)
    {
	if ((*str >= 'A') && (*str <= 'Z'))
	    *str |= 040;		/*and in the lower case bit*/
	str++;
    }
    return;
}
