
; This program prints the raw keyboard data that it gets. Press ESC to quit.
;
; Link this program with KB32.

        .386p
        jumps
code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include start32.inc
include kb32.inc

public  _main

;
; DATA
;
done            db      0               ; done flag

;
; CODE
;

;
_main:
        @rlp edi,0b8000h                ; clear screen
        mov eax,7200720h
        mov ecx,(80*25)/2
        rep stosd

        call _init_kb                   ; initialize KB driver
        mov _kbhand,offset kbh

delay:                                  ; wait till done flag is set
        cmp done,1
        jne delay

        call _reset_kb
        jmp _exit

;
kbh:
        cmp al,1                        ; is it ESC
        jne short kbhf0

        mov done,1                      ; set done flag
        ret

kbhf0:
        @rlp edi,0b8000h                ; put code to screen buffer
        mov ebx,offset _hextbl
        mov ah,0fh
        mov dl,al
        shr al,4
        xlat
        stosw
        mov al,dl
        and al,0fh
        xlat
        stosw
        ret


code32  ends
        end

