;	DESC:	Provides help to the user for all programs           V1.03
;		linking to the help module and following the
;		specified format
;	IN:	*{DS} value passed to data segment at start of main program
;		*{HELP} location of help data
;	OUT:	*{SEG_VAL} segment and
;		*{OFFSET} offset of parameter string
;		*{LENGTH} length of parameter string
;	SAMPLE:	Call	HELP,<DS,HELP>,<SEG_VAL,OFFSET,LENGTH>
;	##################################################################

HELP?	Segment Para Public 'HELPINFO'
		DB	0DH,0AH,'               '
		DB	'             H E L P   O P T I O N S              '
		DB	0DH,0AH,'               '
		DB	'                                                  '
		DB	0DH,0AH,'               '
		DB	'blank line..............This Information          '
		DB	0DH,0AH,'               '
		DB	'/l......................licences and Subroutines  '
		DB	0DH,0AH,'               '
		DB	'?.......................Program Parameters        '
		DB	0DH,0AH,'               '
		DB	'                                                  '
HELP?	Ends

HELPD	Segment Para Public 'HELPDATA'
SNAME		DB	'CoreTechs'
HELPD	Ends

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	TEXT_WRT:Near			;writes text to screen.
	Extrn	PARM_GET:Near			;gets parameters.
	Extrn	CLEAR:Near			;clears the screen.
	Extrn	CURS_SET:Near			;sets the cursor position.
	Extrn	SEARCH:Near			;search for licences.

HELPC	Segment
	Assume	CS:HELPC,DS:HELPD
	Public	HELP

	Include	CALLM.MAC			;include macro.

						;notice.
	DB	'HELP     - V1.03, Copyright 1987, CoreTechs   ',0DH,0AH

HELP	Proc	Near
	Call	PUSHALL				;save registers.

	Pop	AX				;help information.
	Pop	BX				;initial data area.

	Mov	DI,CX				;save end of program mark.
	Callm	PARM_GET,<BX>,<ES,BP,CX>	;get input parameters.
	Mov	DS,AX

	Call	CLEAR				;clear screen.

	Jcxz	RQ1				;program options.

	Cmp	ES:BYTE PTR[BP],'?'		;request for options.
	Jnz	RQ20				;test other options.
	Jmp	RQ0

RQ20:	Cmp	ES:WORD PTR[BP],'l/'		;print licences and subs.
	Jz	RQ200
	Jmp	OK

RQ200:	Jmp	RQ2				;gets around relative jump.

RQ1:	Callm	TEXT_WRT,<0,0,HELP?,0,402>,	;print possible options.
	Jmp	OUT

RQ0:	Callm	TEXT_WRT,<DS:[0],DS:[2],DS:[6],DS:[4],DS:[8]>,

OUT:	Callm	CURS_SET,<1800H,0>,
	Mov	AH,4CH				;exit program.
	Int	21H

OK:	Push	CX				;return input parameters.
	Push	BP
	Push	ES

	Call	POPALL				;recover registers.
	Ret

RQ2:	Mov	AX,0
	Push	AX				;save dummy.

						;search for licence marks.
RQ21:	Pop	BX				;save 

	Callm	SEARCH,<0,CS,BX,9,HELPD,0>,<AX,BX>
	Add	BX,30H				;move past licence.
	Push	BX
	Sub	BX,30H

	Cmp	AX,0				;if AX and BX are 0 then
	Jz	TST2				;no more licences were found.
	Jmp	DISP1

OUT2:	Pop	AX				;release BX.
	Jmp	OUT

TST2:	Cmp	BX,0			
	Jz	OUT2
	
DISP1:	Cmp	CS:WORD PTR[BX+12],0A0DH	;verify licence.
	Jnz	RQ21
	Mov	CS:WORD PTR[BX+12],2020H	;modify licence to
						;not match again.

	Sub	BX,22H				;display licence n.
	Mov	DX,BX
	Add	DX,30H
	Callm	TEXT_WRT,<0,1800H,AX,BX,DX>,

	Mov	AX,0601H			;move screen up one
	Mov	CX,0				;line to prepare for
	Mov	DX,184FH			;display of next licence.
	Mov	BH,07H
	Int	10H				;execute screen move.
	Jmp	RQ21

HELP	Endp
HELPC	Ends
	End
