;	DESC:	Convert Hex numbers to decimal in ASCII format       V1.03
;	IN:	*{HI_HEX} High order word of 4 byte hexadecimal number
;		*{LO_HEX} Low order word of 4 byte hexadecimal number
;	OUT:	*{ASC_1} five words from MSB to LSB with leading
;		*{ASC_2} zeros stripped
;		*{ASC_3}
;		*{ASC_4}
;		*{ASC_5}
;	SAMPLE:	Callm	HEX_ASC,<HI_HEX,LO_HEX>,
;				<ASC_1,ASC_2,ASC_3,ASC_4,ASC_5>
;	##################################################################

HEX_ASCD Segment Para Public 'DATA'
		DB	10 DUP(30H)
ZEROS		DB	30H
		DB	10 DUP(20H)
BLANKS		DB	20H
HIWRD		DW	0
LOWRD		DW	0
ZERO		DB	10 DUP(0)
SET		DB	0
CNT		DB	0
POS		DW	0FFFFH
TEN		DB	10
TOTAL		DB	10 DUP(0)
ENDTOT		DB	0
MULTS		DB	1,9 DUP(0)
		DB	6,1,8 DUP(0)
		DB	6,5,2,7 DUP(0)
		DB	6,9,0,4,6 DUP(0)
		DB	6,3,5,5,6,5 DUP(0)
		DB	6,7,5,8,4,0,1,3 DUP(0)
		DB	6,1,2,7,7,7,6,1,2 DUP(0)
		DB	6,5,4,5,3,4,8,6,2,0
HEX_ASCD Ends

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

HEX_ASCC	Segment
	Assume CS:HEX_ASCC,DS:HEX_ASCD
	Public	HEX_ASC
						;notice.
	DB	'HEX_ASC  - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

HEX_ASC	Proc	Near
	Call	PUSHALL

	Mov	AX,HEX_ASCD			;setup workarea.
	Mov	DS,AX

	Pop	LOWRD				;recover hex number.
	Pop	HIWRD

	Mov	SET,0				;clear counters.
	Mov	CNT,0
	Mov	POS,0FFFFH

	Push	DS				;equate ES to workarea.
	Pop	ES

	Mov	SI,OFFSET ZERO			;clear total to zeros.
	Mov	DI,OFFSET TOTAL
	Mov	CX,10
	Cld
	Rep	MOVS	ES:BYTE PTR[DI],DS:[SI]

TOP:	Inc	POS				;move to first nibble of 8.
	Cmp	POS,8				;if last nibble processed
	Jz	FINI				;then exit.

	Mov	AX,LOWRD			;process low word first.
	Cmp	POS,4				;if >= 4th nibble then
	Jb	LO
	Mov	AX,HIWRD			;process high word.

LO:	Mov	BX,POS				;position is a measure of
	Cmp	POS,4				;4 when number is being
	Jb	LO2				;treated as high and low words
	Sub	BX,4				;so BX holds relative offset.

LO2:	Mov	CX,2				;CX holds bit offset, so
	Shl	BX,CL				;position values of 1,2,3,4
	Mov	CX,BX				;correspond to bit values of
						;4,8,12,16.

	Shr	AX,CL				;all bits to right and left
	And	AX,000FH			;of subject nibble are
						;cleared.

	Mov	CNT,AL				;determines repetition count
						;for looping.

DECWRD:	Cmp	CNT,0				;is loop completed?
	Jz	TOP				;if so, work on next nibble.

	Dec	CNT				;decrease loop counter.
	Mov	AX,POS				;compute offset into multi-
	Mul	TEN				;plier.

	Mov	BX,OFFSET MULTS			;find total offset.
	Add	BX,AX

	Mov	BP,OFFSET TOTAL			;add number in total to
NEXWRD:	Mov	AX,DS:WORD PTR[BP]		;portion of multiplier.
	Mov	CX,DS:WORD PTR[BX]
	Add	AL,CL

	Aaa					;adjust numbers over 9 to
	Mov	DS:WORD PTR[BP],AX		;high part of word and resave.

	Cmp	BP,OFFSET ENDTOT-1		;if total has been processed
	Jz	DECWRD				;handle next bit.

	Inc	BP				;flip carry bit through
	Inc	BX				;entire total.
	Jmp	NEXWRD

FINI:	Mov	BX,OFFSET TOTAL			;convert bit string answer
	Or	DS:WORD PTR[BX],3030H		;to ASCII digits.
	Or	DS:WORD PTR[BX+2],3030H
	Or	DS:WORD PTR[BX+4],3030H
	Or	DS:WORD PTR[BX+6],3030H
	Or	DS:WORD PTR[BX+8],3030H

	Mov	SI,OFFSET ENDTOT-1		;locate first nonzero digit
	Mov	DI,OFFSET ZEROS			;in result and convert
	Mov	CX,10				;leading zeros to blanks.
	Std
	Rep	CMPSB

	Mov	AX,OFFSET ZEROS			;break out number of zeros.
	Sub	AX,DI
	Dec	AX

	Mov	SI,OFFSET BLANKS		;replace with blanks.
	Mov	CX,AX
	Mov	DI,OFFSET ENDTOT-1
	Std
	Rep	MOVS	ES:BYTE PTR[DI],DS:[SI]

	Mov	BX,OFFSET TOTAL			;return result in five words
	Push	DS:WORD PTR[BX]			;from MSW to LSW.
	Push	DS:WORD PTR[BX+2]
	Push	DS:WORD PTR[BX+4]
	Push	DS:WORD PTR[BX+6]
	Push	DS:WORD PTR[BX+8]

	Call	POPALL				;restore registers.
	Ret

HEX_ASC	Endp
HEX_ASCC	Ends
	End
