;	DESC:	Gets parameters passed to program from DOS level     V1.00
;		at DS+80H
;	IN:	*{DS} value passed to data segment at start of main program
;	OUT:	*{SEG_VAL} segment and
;		*{OFFSET} offset of parameter string
;		*{LENGTH} length of parameter string
;	SAMPLE:	Callm	PARM_GET,<DS>,<SEG_VAL,OFFSET,LENGTH>
;	###################################################################

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

PARM_GEC	Segment
	Assume	CS:PARM_GEC
	Public	PARM_GET

						;notice.
	DB	'PARM_GET - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

PARM_GET	Proc	Near

	Call	PUSHALL				;save registers.

	Pop	DS				;recover data segment.

	Mov	BP,81H				;offset to parameter.

	Xor	AH,AH				;clear top of AX.

	Mov	AL,DS:BYTE PTR[80H]		;get length of parameter block
	Add	BP,AX				;and find offset to end.

	Push	AX				;return length of parameter.

	Mov	AX,82H				;return offset of block.
	Push	AX

	Push	DS				;return segment of block.

	Mov	AX,0				;place 0 byte at end of block.
	Mov	DS:[BP],AX

	Call	POPALL				;recover registers.
	Ret

PARM_GET	Endp
PARM_GEC	Ends
	End
