;	DESC:	Replaces an occurence of a string with another       V1.00
;		string
;	IN:	*{RSTRNG} segment and
;		*{ROFF} offset of replacement string (must be same length)
;		*{DIR} direction of search (0:forward,1-FFFF:reverse)
;		*{SEG_VAL} segment and
;		*{OFFSET} offset of buffer to search
;		*{LENGTH} length of search string
;		*{SSTRNG} segment and
;		*{OSTRNG} offset of search string
;	OUT:	*{OSEG} segment and
;		*{OOFF} offset of replacement (both zero if not replaced)
;	SAMPLE:	Callm	REPLACE,<RSTRNG,ROFF,DIR,SEG_VAL,OFFSET,LENGTH,
;		        SSTRNG,OSTRNG>,<OSEG,OOFF>
;	####################################################################

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	SEARCH:Near
	Extrn	MOVE_BYT:Near

REPLACEC	Segment
	Assume	CS:REPLACEC
	Public	REPLACE

	Include	CALLM.MAC
						;notice.
	DB	'REPLACE  - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

REPLACE	Proc	Near
	Call	PUSHALL				;save registers.

	Pop	AX
	Pop	BX
	Pop	CX				;recover length of search
	Push	CX				;string and replace
	Push	BX				;parameters.
	Push	AX

	Call	Search				;perform search with arguments
						;already on stack.

	Pop	AX				;recover segment and
	Pop	BP				;offset of match.

	Cmp	AX,0				;if both zero nothing found.
	Jz	TST2
	Jmp	CONT

TST2:	Cmp	BP,0
	Jz	OUT2


CONT:	Cld
	Callm	MOVE_BYT,<AX,BP,CX>,		;add additional parameters
						;to call. input buffer address
						;is already on stack.

OUT:	Push	BP				;return address of replace.
	Push	AX

	Call	POPALL				;recover registers.
	Ret

OUT2:	Pop	BX
	Pop	BX
	Jmp	OUT

REPLACE	Endp
REPLACEC	Ends
	End
