;	DESC:	search for the previous file of a set of filenames   V1.00
;
;	***	CX must be loaded with the appropriate file attribute
;		to search on (1:read only,2:hidden file,
;		 4:system file,8:volume label,10H:sub-directory,
;		 20H:archived file).                              ***
;
;	IN:	*{SEG_VAL} segment and
;		*{OFFSET} offset of search string
;	OUT:	*{TIME} time file last written
;		*{DATE} date file last written
;		*{SIZE_LO} low word of file size
;		*{SIZE_HI} high word of file size
;		*{OUT_SEG} segment and
;		*{OUT_OFF} offset of first matching filename
;		*{LENGTH} length of filename found, 0 if not found
;	SAMPLE:	SRCH_PRE,<SEG_VAL,OFFSET>,
;		         <TIME,DATE,SIZE_LO,SIZE_HI,OUT_SEG,OUT_OFF,LENGTH>
;	################################################################

SRCH_FID Segment Para Common 'DATA'
TRANSFER	DB	80H DUP(0)		;temporary data transfer area.
THIRTY		DW	30			;value of number thirty.
SEGER		DW	0			;segment and offset of stored
OFFER		DW	0			;old data area.
CFILE		DW	0			;current file number.
PFILE		DW	0			;previous file number.
SRCH_FID ENDS
 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	SRCH_NXT:Near

SRCH_PRC	SEGMENT
	ASSUME	CS:SRCH_PRC,DS:SRCH_FID
	Public	SRCH_PRE

						;notice.
	DB	'SRCH_PRE - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

SRCH_PRE	Proc	Near
	Call	PUSHALL				;save registers.

	Mov	AX,SRCH_FID			;setup workarea.
	Mov	DS,AX

	Pop	AX				;discard filename info.
	Pop	AX

	Mov	AX,DS:WORD PTR[13]		;recover filenumber within
						;directory and move back to
						;previous filename.

	Mov	PFILE,AX			;initialize previous file#s.
	Mov	CFILE,AX

	Sub	PFILE,2				;move back two files because
						;call to SRCH_NXT will move
						;to next file in list.

LOOK:	Mov	AX,PFILE			;reload filenumber in DTA.
	Mov	DS:WORD PTR[13],AX

	Push	AX				;send in dummy arguments.
	Push	AX

	Call	SRCH_NXT			;search for next file.

	Cmp	PFILE,2				;if search passes first entry
	Jb	LEAV				;in dir., then abort.

	Dec	PFILE				;else, move to previous file.

	Mov	AX,CFILE			;see if file is before current
	Cmp	DS:WORD PTR[13],AX		;filenumber.
	Jb	LEAV

	Pop	AX				;drop returned file info
	Pop	AX				;if this is not the correct
	Pop	AX				;filename.
	Pop	AX
	Pop	AX
	Pop	AX
	Pop	AX
	Jmp	LOOK				;continue search.

LEAV:	Call	POPALL				;recover registers.
	Ret

SRCH_PRE	Endp

SRCH_PRC	Ends
	End
