	.xlist
	page 66,132
title	Video Interrupt Interceptor to Kill Color Displays -- DOS 2.0 Version
subttl Permanently resident portion
	PAGE
	.list
interseg	SEGMENT	PARA PUBLIC 'CODE'
	ASSUME	CS:interseg,ds:interseg
changevectint = 25h	; DOS function code for "change interrupt vector"
getvectint = 35h	; DOS function code for "get interrupt vector"
setvideomode = 0	; subcode for "set video mode"
termbutstayres = 27h	; interrupt code for "terminate but stay resident"
start	equ	$
	org	100h
entrypoint:
	jmp	nonresidentportion

; the following code and data will remain resident for the processing of
; 	interrupts and permanent processing
;
; data section
savevect	dd	?	; location in which to save original vector
;
;
;
;
interruptroutine:
	cmp	ah,setvideomode	; is this the "set mode" function ?
	jne	go_on		; br if no
	cmp	al,4		; is this the special case ?
	je	special		; yes, handle it
	and	al,0feh		; for all others, turn off the low bit
				; --- that is the only difference between bw and color
go_on:
	jmp	cs:savevect	; jump to regular routine in rom
special:
	inc	al		; change color 320X200 to b/w 320X200
	jmp	go_on		; jump to common exit
; align the interrupt routine on a paragraph boundary
	if	($-start) mod 16
	org 	($-start)+16-(($-start) mod 16)
	endif
endofresident:
	.xlist
subttl Non-resident portion --- to be deleted after execution
	PAGE
	.list
nonresidentportion:

; code following the symbol endofresident, starting with symbol nonresidentportion
; 	is transient and will be overlaid at the initial exit
;

	mov	si,offset savevect ; get offset of address to store vector
	mov	al,vectnum	; get vector number
	mov	ah,getvectint 	; indicate get vector function
	int	21h	 	; Call DOS
	mov	ax,bx		; get offset of vector
	mov	[si],ax	 	; store it in local address space
	mov	ax,es		; get segment of vector
	mov	2[si],ax	; store it in local address space
	mov	al,vectnum	; get vector number
	mov	ah,changevectint ; indicate change vector function
	mov	dx,offset interruptroutine ; point dx to my interrupt routine
	int	21h	 	; Call DOS
	mov	dx,offset endofresident ; get end of resident portion
	int	termbutstayres	; terminate, but stay resident

vectnum	db	10h		; vector number of interrupt we wish to replace
interseg	ENDS
	END	entrypoint
