/* Firmware Furnace Embedded '386SX Projects...                              */
/* Standard include file for Journey to the Protected Land programs          */

/*---------------------------------------------------------------------------*/
/* Galactic standard PC addresses and so forth                               */

#define I8259A    0x20                 /* primary interrupt controller       */
#define I8259B    0xA0                 /* secondary interrupt controller     */

#define I8259A_VECTOR   0x08           /* Primary controller base vector     */
#define I8259B_VECTOR   0x70           /*  ... ditto, secondary controller   */

#define I8259A_VECTOR_PM  0x50         /* Protected-mode vectors             */
#define I8259B_VECTOR_PM  0x70         /*  ... to avoid reserved INT vectors */

#define NS_EOI    0x20                 /* non-specific End-Of-Interrupt      */

#define SYS_CTLS  0x61                 /* AT system control bit port         */

#define KEY_DATA     0x60              /* keyboard controller data/status    */

#define KEY_CMD      0x64              /* keyboard controller command port   */

#define RTC_ADDR     0x70              /* Real-time clock address port       */
                                       /*  MSB = 1 disables NMI              */

#define RTC_DATA     0x71              /* Real-time clock data port          */

/*---------------------------------------------------------------------------*/
/* Handy stuff                                                               */

#define BYTE unsigned char
#define WORD unsigned int
#define DWORD unsigned long int

#define LADDR unsigned long int        // 32-bit linear address

#define TRUE (1 == 1)                  // avoid the "1 is true" assumption
#define FALSE (!TRUE)                  // similarly


/*--- useful character definitions                                           */
/*    these are in decimal so as to be useful in either C or assembler       */

#ifndef CANCEL

#define CANCEL    3
#define BELL      7
#define BS        8
#define CR        13
#define LF        10
#define TAB       9
#define FORMFEED  12
#define ESC       27
#define BLANK     ' '
#define DEL       127

#define XON       17
#define XOFF      19

#endif

