/* Firmware Development Board                                                */
/* Port addresses and bit locations                                          */

#define BOARD_BASE   0x0300            /* board starting address             */
#define BOARD_SIZE   0x0020            /* address range on board             */

#define NV_SEGMENT   0xC800            /* non-volatile memory base           */
#define NV_SIZE      0x8000            /*  ... and size (32K = -32768!)      */

#define GLCD_SEGMENT 0xD000            /* graphics LCD buffer segment        */
#define GLCD_SIZE    0x8000            /*  ... and size in bytes             */

#define SYNC_ADDR    0x0378            /* LPT port addr for scope syncs &c   */

#define I8254_BASE   (BOARD_BASE+0x0008)           /* base of timer regs     */
#define I8254_NS     139                           /* nanoseconds per count  */

/*--- miscellaneous status and control bits                                  */
/*    char LCD controller data I/O is through the low-order byte             */

#define CTLS_ADDR    (BOARD_BASE+0x001C)           /* write also sets        */

#define WATCHDOG     0x0100                        /* watchdog toggle output */
#define NV_WENABLE   0x0200                        /* 1 = enable NV writes   */
#define DS2400OUT    0x0400                        /* DS2400 data output     */
#define LCD_E        0x1000                        /* LCD Enable signal      */
#define LCD_RW       0x2000                        /* LCD Rd/-Wr signal      */
#define LCD_RS       0x4000                        /* LCD Register Select    */
#define LCD_NODRV    0x8000                        /* +Disable data to LCD   */

#define STAT_ADDR    (BOARD_BASE+0x001C)

#define PWR_GOOD     0x0100                        /* 1 = power is still OK  */
#define PUSHBUTTON   0x0200                        /* pushbutton input       */
#define DS2400IN     0x0400                        /* DS2400 data output     */

/*--- Graphics LCD interface                                                 */
/*    Note that some of the bits are minus-active and plus-disabling         */
/*    Use a bit-or (|) to combine the bits...                                */

#define GLCD_CTLS    (BOARD_BASE+0x01A)

#define GLCD_ENCTR     0x0001                      /* enable addr counters   */
#define GLCD_DISMUX    0x0002                      /* 1 disabled output mux  */
#define GLCD_ENDISP    0x0004                      /* enable LCD (if used)   */

#define GLCD_BLSLOW    0x0050                      /* slowest blinking       */
#define GLCD_BLMED     0x0040                      /* moderate blinking      */
#define GLCD_BLFAST    0x0030                      /* fastest blinking       */
#define GLCD_BLZERO    0x0000                      /* output logic zero      */
#define GLCD_BLCLOCK   0x0060                      /* output LCD clock       */
#define GLCD_BLONE     0x0070                      /* output logic one       */

#define GLCD_OFF     (GLCD_DISMUX | GLCD_DISBLINK)
#define GLCD_ON      (GLCD_ENCTR | GLCD_ENDISP)

/*--- LEDs and DIP switch inputs                                             */

#define LED_ADDR     (BOARD_BASE+0x001E)           /* offset of LED latches  */
#define SW_ADDR      (BOARD_BASE+0x001E)           /* offset of switch inputs*/


