#include <stdio.h>
#include "key.h"

#define MAXSTRLEN 65

void main(void)
{
    char    mystr[MAXSTRLEN+1];
    int     mystrlen = 0;

    for (mystrlen = 0; mystrlen < MAXSTRLEN+1; mystrlen++)
        mystr[mystrlen] = 0;

    printf("Multiple key test program by Patch\n");
    printf("\n");
    printf("Read KEY.DOC for more info.\n");
    printf("The magic key is LEFTSHIFT and KEYPAD8.\n");
    printf("Hit any key to start, Esc to stop\n\n");

    Set_New_Int9();
    ClearKeys();
    do GetKey(); while (keylast == 0);

    while (keys[kESC] != 1)
    {
        if (keys[kLEFTSHIFT] == 1 && keys[kKEYPAD8] == 1)
            printf("You pressed the magic key combo!\n");
        else
            printf("keynumpress = %d\n",keynumpress);
    }

    printf("Now input a string ... hit any key to start, Enter to stop\n");
    ClearKeys();
    do GetKey(); while (keylast == 0);
    ClearKeys();

    mystrlen = 0;
    while (keylast != bENTER)
    {
        if (keylast == bBACKSPACE && mystrlen > 0)
        {
            mystrlen--;
            mystr[mystrlen] = 0;
        }
        else if (mystrlen < MAXSTRLEN && (keylast == ' ' ||
                 (keylast >= 'a' && keylast <= 'z') ||
                 (keylast >= 'A' && keylast <= 'Z') ||
                 (keylast >= '0' && keylast <= '9')))
                {
                    mystr[mystrlen] = keylast;
                    mystrlen++;
                }

        printf("mystr = [%s]\n",mystr);
        GetKey();
    }

    Set_Old_Int9();
}
