ideal
locals
jumps
model huge
stack 100h

segment Code
        assume cs:Code
;
include "lens.inc"
SourceBuffer    db  LensDiameter*LensDiameter dup(?)
TargetBuffer    db  LensDiameter*LensDiameter dup(?)
NoMouse         db  'No mouse installed.',0Dh,0Ah,'$'
TGA_filename    db  'LENS.TGA',0
TGA_handle      dw  ?
PositionX       dw  ?
PositionY       dw  ?
;
proc    Start
        ;check to make sure a mouse is present
        mov ax,0
        int 33h
        cmp ax,0
        jnz @@GotMouse
        mov ah,9
        push cs
        pop ds
        mov dx,offset NoMouse
        int 21h
        mov ax,4C00h
        int 21h

@@GotMouse:
        ;switch over to graphics mode
        mov ax,0013h
        int 10h

        ;define the limits of the mouse
        mov ax,0007h
        mov cx,0
        mov dx,(320-LensDiameter)*2-1
        int 33h
        mov ax,0008h
        mov cx,0
        mov dx,(200-LensDiameter)-1
        int 33h

        ;find out the current location of the mouse and save it
        mov ax,3
        int 33h
        mov [cs:PositionX],cx
        mov [cs:PositionY],dx

        ;load in a pretty picture to look at
        call LoadTGA

@@MainLoop:
        ;read in the portion of the screen we're going to work on
        call FetchBuffer

        ;put it under the lens
        call MorphBuffer

        ;display the new buffer
        call DisplayNewBuffer

@@WaitForMovement:
        ;read in the mouse position, if it's changed, then reupdate
        mov ax,3
        int 33h
        shr cx,1
        cmp [cs:PositionX],cx
        jnz @@ItMoved
        cmp [cs:PositionY],dx
        jnz @@ItMoved

        ;get stdio.  If something's been pressed, quit
        mov ah,6
        mov dl,0FFh
        int 21h
        jz @@WaitForMovement
        jmp @@Quit

@@ItMoved:
        push cx dx

        ;restore what was originally on the screen
        call RestoreBuffer

        pop dx cx

        ;save the new position
        mov [cs:PositionX],cx
        mov [cS:PositionY],dx
        jmp @@MainLoop

@@Quit:
        ;change back to text mode and quit
        mov ax,0003h
        int 10h
        mov ax,4C00h
        int 21h
endp    Start
;
;read in the portion of the screen that we're working on into a buffer
proc    FetchBuffer
        mov ax,0A000h
        mov ds,ax
        push cs
        pop es
        mov si,[cs:PositionY]
        mov ax,320
        mul si
        mov si,ax
        add si,[cs:PositionX]
        mov di,offset SourceBuffer
        mov cx,LensDiameter
@@CopyRow:
        push si cx
        mov cx,LensDiameter
        cld
        rep movsb
        pop cx si
        add si,320
        dec cx
        jnz @@CopyRow

        ret
endp    FetchBuffer
;
;put the portion of the screen that we've captured under the lens
proc    MorphBuffer
        mov ax,cs
        mov ds,ax
        mov es,ax
        mov si,offset Lens
        mov di,offset TargetBuffer
        mov cx,LensDiameter*LensDiameter
        cld
        xor bh,bh
@@DoPoint:
        lodsw
        mov bx,ax
        mov al,[byte offset SourceBuffer+bx]
        stosb
        inc dx
        dec cx
        jnz @@DoPoint

        ret
endp    MorphBuffer
;
;display the new calculated buffer
proc    DisplayNewBuffer
        mov ax,0A000h
        mov es,ax
        push cs
        pop ds
        mov di,[cs:PositionY]
        mov ax,320
        mul di
        mov di,ax
        add di,[cs:PositionX]
        mov si,offset TargetBuffer
        mov cx,LensDiameter
@@CopyRow:
        push di cx
        mov cx,LensDiameter
        cld
        rep movsb
        pop cx di
        add di,320
        dec cx
        jnz @@CopyRow

        ret
endp    DisplayNewBuffer
;
;restore the unmagnified portion of the image on screen
proc    RestoreBuffer
        mov ax,0A000h
        mov es,ax
        push cs
        pop ds
        mov di,[cs:PositionY]
        mov ax,320
        mul di
        mov di,ax
        add di,[cs:PositionX]
        mov si,offset SourceBuffer
        mov cx,LensDiameter
@@CopyRow:
        push di cx
        mov cx,LensDiameter
        cld
        rep movsb
        pop cx di
        add di,320
        dec cx
        jnz @@CopyRow

        ret
endp    RestoreBuffer
;
;load a TGA and display it
proc    LoadTGA
        push cs
        pop ds
        mov ax,3D00h
        mov dx,offset TGA_filename
        int 21h
        jc @@Quit
        mov [cs:TGA_handle],ax

        mov ah,3Fh
        mov bx,[cs:TGA_handle]
        mov cx,18
        mov dx,offset ReadBuffer
        int 21h
        jc @@Quit
        
        mov ah,3Fh
        mov bx,[cs:TGA_handle]
        mov cx,768
        mov dx,offset ReadBuffer
        int 21h
        jc @@Quit

        mov cx,256
        push cs
        pop ds
        push cs
        pop es
        mov si,offset ReadBuffer
        mov di,offset ReadBuffer
        cld
@@FixPal:
        lodsb           ;\
        shr al,2        ; > load in Blue component
        mov ah,al       ;/
        lodsb           ;\
        shr al,2        ; > load in Green component
        mov bh,al       ;/
        lodsb           ;\ load in Red component
        shr al,2        ;/
        stosb           ;write out Red
        mov al,bh       ;\ write out Green
        stosb           ;/
        mov al,ah       ;\ write out Blue
        stosb           ;/
        dec cx
        jnz @@FixPal

        mov ax,1012h
        mov bx,0
        mov cx,256
        push cs
        pop es
        mov dx,offset ReadBuffer
        int 10h

        mov ah,3Fh
        mov bx,[cs:TGA_handle]
        mov cx,64000
        mov dx,0A000h
        mov ds,dx
        mov dx,0
        int 21h
        jc @@Quit

        mov ah,3Eh
        mov bx,[cs:TGA_handle]
        int 21h

@@Quit:
        ret
endp    LoadTGA
;
label   ReadBuffer byte
ends    Code
        end     Start
