; File......: NOVDMP2.ASM
; Author....: David Minter
; CIS ID....: 76247,3475
; Date......: $Date:   17 Aug 1991 15:36:38  $
; Revision..: $Revision:   1.3  $
; Log file..: $Logfile:   E:/nanfor/src/novdmp2.asv  $
;
; This is an original work by David Minter and hereby placed into
; the public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/novdmp2.asv  $
;  
;     Rev 1.3   17 Aug 1991 15:36:38   GLENN
;  Don Caton fixed some spelling errors in the doc
;  
;     Rev 1.2   15 Aug 1991 23:07:00   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:46   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:34   GLENN
;  Nanforum Toolkit
;  
;


; $DOC$
; $FUNCNAME$ 
;    FT_NOVDMP2()
; $CATEGORY$
;    NetWare
; $ONELINER$
;    Determine Novell server's dynamic memory area 2 availability
; $SYNTAX$
;    FT_NOVDMP2() -> nDMP2
; $ARGUMENTS$
;    None
; $RETURNS$
;    The total available dynamic memory area 2 on current server, in bytes.
; $DESCRIPTION$
;   This function is used primarily on Novell 2.15 TTS Servers.  Dynamic
;   Memory area 2 is where the transaction tracking takes place.  This
;   function allows you to query the ability of the server to handle any
;   transactions you may wish to start.  (I personally don't let the area 
;   fall below 8K).  It is generally only useful in large batch situations
;   and if you are using NETLIB's TTS capability.
;
; $EXAMPLES$
;   t_trans(ON)       // Netlib function
;   DO WHILE FT_NOVDMP2() > 8000 .AND. ! Eof()
;		
;      REPLACE foo WITH 'bar'
;      SKIP
;
;   ENDDO
;   t_trans(OFF)
;
;   $END$



                include         minter.mac
extrn           __RETNL:FAR
.MODEL	large, PASCAL
.data
req_buf		dw	1
subfun		db	232
rep_buf		dw	56
elap_time	dd	?
proc_type	db	?
reserved	db	?
serv_proc	db	?
utilization	db	?
cmbind		dw	?
ambind		dw	?
curmbind	dw	?
totmem		dw	?
wasmem		dw	?
records		dw	3
totd1		dd	?
maxd1		dd	?
curd1		dd	?
totd2		dd	?
maxd2		dd	?
curd2		dd	?
totd3		dd	?
maxd3		dd	?
curd3		dd	?
.CODE
FT_NOVDMP2      PROC    FAR

@SAVE  	ds,es,si,di

start:		mov	ax, @data
		mov	ds, ax
		mov	es, ax
		mov	si,OFFSET req_buf
		mov	di,OFFSET rep_buf

;; ***   set up the registers
		mov	ah,227
		mov	al,0

		int	21h

;; ***   copy to the return variable


@RESTORE	ds,es,si,di

		mov	al,BYTE PTR totd2[1]
		mov	ah,BYTE PTR totd2[0]
		mov	dl,BYTE PTR totd2[3]
		mov	dh,BYTE PTR totd2[2]

		mov	bl,byte ptr curd2[1]
		mov	bh,byte ptr curd2[0]

		sub	ax,bx

		mov	bl,byte ptr curd2[3]
		mov	bh,byte ptr curd2[2]

		sbb	dx,bx
		
		push	ax
		push	dx
		call	__RETNL
		add	sp,4
                ret
FT_NOVDMP2      ENDP
                END

