; This program uses FILE and ARGC to copy one file to another.

        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include file.inc
include argc.inc

public  _main

;
; DATA
;

input_fnm       db      80h dup(?)
output_fnm      db      80h dup(?)

msg0            db      'SYNTAX: EX_PM5 <input filename> <output filename>$'
msg1            db      'Not enough low memory to allocate low file buffer.$'
msg2            db      'Could not open input file.$'
msg3            db      'Not enough memory to load input file.$'
msg4            db      'Error reading from input file.$'
msg5            db      'Output file already exists, will not overwrite.$'
msg6            db      'Could not create output file.$'
msg7            db      'Error writing to output file.$'
msg8            db      'File copied successfully.$'

;
; CODE
;

;
_main:
        sti

        mov al,1                        ; get 2nd string on command line if
        mov edx,offset output_fnm       ;  present
        call _cchekstr
        jc done0
        xor al,al                       ; 2nd string present, so the first is
        mov edx,offset input_fnm        ;  definately there
        call _cchekstr

        movzx eax,_filebuflen           ; allocate low memory for file buffer
        call _getlomem                  ;  it will only be used if high memory
        jc done1                        ;  is needed to load in the full input
        mov _filebufloc,eax             ;  file

        mov edx,offset input_fnm        ; try to open input file
        call _openfile
        jc done2

        call _filesize                  ; opened, get its size

        mov ebp,eax                     ; preserve size for later use
        call _getmem                    ; allocate that much mem, low or high
        jc done3

        mov edi,eax                     ; preserve ptr for later use
        mov edx,eax                     ; read in whole file
        mov ecx,ebp
        call _readfile
        jc done4

        call _closefile                 ; close input file

        mov edx,offset output_fnm       ; try to open output file, if it opens
        call _openfile                  ;  then its already present and we
        jnc done5                       ;  will not overwrite it

        call _createfile                ; does not exist, create it
        jc done6

        mov edx,edi                     ; write data from input file to output
        mov ecx,ebp
        call _writefile
        jc done7

        call _closefile                 ; close output file

        mov edx,offset msg8
        jmp done

;
done0:
        mov edx,offset msg0
        jmp short done
;
done1:
        mov edx,offset msg1
        jmp short done
;
done2:
        mov edx,offset msg2
        jmp short done
;
done3:
        mov edx,offset msg3
        jmp short done
;
done4:
        call _closefile
        mov edx,offset msg4
        jmp short done
;
done5:
        call _closefile
        mov edx,offset msg5
        jmp short done
;
done6:
        mov edx,offset msg4
        jmp short done
;
done7:
        call _closefile
        mov edx,offset msg5
;-----------------------------------------------------------------------------
done:
        add edx,_code32a                ; put message with INT 21h AH=9
        shld eax,edx,28
        and edx,0fh
        mov v86r_ds,ax
        mov v86r_dx,dx
        mov v86r_ah,9
        mov al,21h
        int 33h

        jmp _exit

code32  ends
        end

