/*********************************************************************
** QFML DEMO :
**   ALTHOUGH THIS LISTING CAN'T BE MODIFIED, IT SHOWS HOW QFM WORKS.
**   JUST SHOWS HOW TO USE SOME POKE'S AND PEEK'S.
**
** (C) RENDER OF ACC TEAM (1995)
*********************************************************************/

#include "qfml.h"
#include <stdio.h>
#include <stdlib.h>

#define dword unsigned long int

void
main(void)
{
    dword First_addr;                 // Keeps starting QFM's memory address
    dword MCGA_off;                   // Plane address of video mem.
    dword num_ks;                     // Keeps the amount of K's reserved

    // First of all start QFM before leaving textmode
    if (StartPL()) exit(1);

    // Then open the whole mem after the first Megabyte.
    if (OpenMem()) {
      LeavePL();           // Leave QFM mode before leaving your code.(ALWAYS)
      exit(1);
    }

    // We get the amount of memory available
    num_ks=GiveAmo();
    if (num_ks<1) {        // We need a minimum of 1 k
      CloseMem();          // Close mem. before leavinf QFM. (ALWAYS)
      LeavePL();           // Leave QFM mode before leaving your code.(ALWAYS)
    }
    printf ("Available memory after first Mgb. (Kbytes):%lu\n",num_ks);

    // Then we need the starting address of this block in plane
    // memory. Observe it will always be after position 1048576 (1Mb)
    First_addr=GiveSta();


    // First Poke data and then peek it to check it
    Pokeb(First_addr+10,101);
    printf ("Peekb(%lu)=%d\n",First_addr+10,Peekb(First_addr+10));

    Pokew(First_addr+10,0xFFFF);
    printf ("Peekw(%lu)=%u\n",First_addr+10,Peekw(First_addr+10));

    Pokedw(First_addr+10,0x00010001);
    printf ("Peekdw(%lu)=%lu\n",First_addr+10,Peekdw(First_addr+10));


    // Close openned mem. before living
    CloseMem();

    // Leave QFM before termination
    LeavePL();
}























