program AppendRandom;
{
   Sample program to show how to access the RANTSR random number
   generator.  Since RANTSR generates only one byte per keystroke,
   it is best to use the generator only to seed a traditional
   pseudo-random number generator

   Joseph R Ahlgren     BBS 703-241-7980        }

{$N-}
  uses Dos;
  var
    f: file;
    r: registers;
    a: array [1..256] of byte;
  begin
    {ask for 0 bytes, just to see if RANTSR is loaded}
    r.ax:=$ae00;
    r.dx:=$726e;
    r.es:=seg(a);
    r.di:=ofs(a);
    intr($2f,r);
    WriteLn('al status=',r.al,'  dx status=',r.dx);
    if (r.al = $ff) and (r.dx = 0) then
      begin
      {ask for 255 bytes}
      r.ax:=$aeff;
      r.dx:=$726e;
      r.es:=seg(a);
      r.di:=ofs(a);
      intr($2f,r);
      WriteLn(r.dx,' random bytes returned, status=',r.al);
      assign(f,'random.log');
      {$I-}
      reset(f,1);
      if IOresult <> 0 then
        {$I+}
        rewrite(f,1)
       else
        seek(f,filesize(f));
      blockwrite(f,a,r.dx);
      WriteLn('New RANDOM.LOG file size is ',filesize(f),' bytes.');
      close(f);
      end
     else
      WriteLn('INT 2F did not return a valid signature, RANTSR not found');
end.