;
; *** Listing 13-9 ***
;
; Counts the number of negative values in a 1000-word array,
; by adding the Sign bit of each array element directly to
; the register used for counting.
;
	jmp	Skip
;
WordArray	label	word
X=-500
	rept	1000
	dw	X
X=X+1
	endm
WORD_ARRAY_LENGTH	equ	($-WordArray)
;
; Counts the number of negative values in a word-sized
; array.
;
; Input:
;	CX = length of array in words
;	DS:SI = pointer to start of array
;
; Output:
;	DX = count of negative values in array
;
; Registers altered: AX, BX, CX, DX, SI
;
; Direction flag cleared
;
; Note: Does not handle arrays that are longer than 32K
;	words or cross segment boundaries.
;
CountNegativeWords:
	cld
	sub	dx,dx	;initialize the count to 0
	mov	bx,dx	;store the constant 0 in BX to speed
			; up ADC in the loop
CountNegativeWordsLoop:
	lodsw		;get the next word from the array
	shl	ax,1	;put the sign bit in the Carry flag
	adc	dx,bx	;add the sign bit (via the Carry
			; flag) to DX, since BX is 0
CountNegativeWordsLoopBottom:
	loop	CountNegativeWordsLoop
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset WordArray
			;point to the array to count
			; the # of negative words in...
	mov	cx,WORD_ARRAY_LENGTH/2
			;...set the # of words to check...
	call	CountNegativeWords
			;...and count the negative words
	call	ZTimerOff
