
Program Bitdemo;
{Contributed by:
 Juergen Schlottke
 46 Schoenaich-C.-Str.
 D-25336 Elmshorn (Germany, so forgive me my English)

 Please send me Your comments, bug fixes, corrections or
 improvements via Compuserve, my Compuserve-ID is 100106,3034

 This is a short demonstration of the BITFIELD Unit and of
 exception error handling with Object Pascal.
 }

{If You want to single step, set conditional define DEBUG}
{$ifdef debug}
  {$R+,S+,D+,A+,B-,G+}
{$else}
  {$R-,S-,D-,A+,B-,G+,T+}
{$endif}

uses
  BitField in 'BITFIELD.PAS',
  sysutils,wincrt;

procedure Showbitarray(s:string;BA:TBitArray);
{Show the string and the Bitarray in a single line}
var i:Longint;
begin
  write(s);
  for i:=0 to BA.BitSize do
    if BA.testbit(i) then write('1') else write('0');
  writeln;
end;


const
  NumBits=50; {Use 50 for working demo
               or 600000 to check error handling}

procedure BitFieldDemo;
var
  BitArray1,BitArray2:TBitArray;
  i:Longint;
  errorfound:boolean;
label ErrorExit;
begin
  {Set bitarray objects to nil}
  Bitarray1:=nil;
  Bitarray2:=nil;
  {Remark:
   If Your objects are part of another object that is dynamically
   created, You dont need to set those pointers to nil, because it
   is done automatically during creation of the parent object. But
   in this case, the objects are build on the stack, and so the
   pointers are not initialized to nil. If the pointer is nil or
   a valid object, then You are allowed to call the "free" method.
   Otherwise "free" will cause most likely a general protection fault.}
  wincrt.windoworg.x:=0;
  wincrt.windoworg.y:=0;
  writeln; {Do a writeln to create the CRT window}
  writeln('Free RAM before creating bitarrays: ',memavail);
  writeln;
  errorfound:=false;
  {Try to create two bitarrays}
  try
    Bitarray1:=TBitArray.Create(numBits);
    BitArray2:=TBitArray.create(numBits);
  except {Oh, an exception happened, show message }
    errorfound:=true;
    showexception(exceptObject,exceptAddr);
    writeln('Error: Demo cannot be executed!');
  end;
  if errorfound then Goto ErrorExit;
  {No exception happened, so do some operations}
  ShowBitarray('Bitarray 1 created: ',Bitarray1);
  {Set defined bits in bitarray 1}
  for i:=1 to numbits do
    if i mod 3=0 then Bitarray1.setbit(i);
  ShowBitarray('Set some bits:      ',Bitarray1);
  {Invert the whole array}
  Bitarray1.invert;
  ShowBitarray('Inverted bitarray:  ',Bitarray1);
  {Toggle some random bits}
  for i:=1 to numbits do
    if random(4)=3 then Bitarray1.togglebit(i);
  ShowBitarray('Toggle random bits: ',Bitarray1);

  write(       'Show another way  : ');
  for i:=0 to 50 do
    if Bitarray1.testbit(i) then write('T') else write('F');
  writeln;
  writeln;
  writeln('Demo of logical operations on bitarrays:');
  {toggle some bits in bitarray 2}
  for i:=1 to numbits do
    if i mod 2=0 then Bitarray2.togglebit(i);
  {Set defined bits in bitarray 1}
  Bitarray1.clear;
  for i:=1 to numbits do
    if i mod 3=0 then Bitarray1.setbit(i);
  ShowBitarray('Bitarray 1:         ',Bitarray1);
  ShowBitarray('Bitarray 2:         ',Bitarray2);
  bitarray1.Logicconnect(bitarray2,LogicAND);
  Showbitarray('Bitarray 1 AND 2:   ',Bitarray1);
  writeln;
  {Set defined bits in bitarray 1}
  Bitarray1.clear;
  for i:=1 to numbits do
    if i mod 3=0 then Bitarray1.setbit(i);
  ShowBitarray('Bitarray 1:         ',Bitarray1);
  ShowBitarray('Bitarray 2:         ',Bitarray2);
  bitarray1.Logicconnect(bitarray2,LogicOR);
  Showbitarray('Bitarray 1 OR 2:    ',Bitarray1);
  writeln;
  {Set defined bits in bitarray 1}
  Bitarray1.clear;
  for i:=1 to numbits do
    if i mod 3=0 then Bitarray1.setbit(i);
  ShowBitarray('Bitarray 1:         ',Bitarray1);
  ShowBitarray('Bitarray 2:         ',Bitarray2);
  bitarray1.Logicconnect(bitarray2,LogicXOR);
  Showbitarray('Bitarray 1 XOR 2:   ',Bitarray1);
  writeln;
ErrorExit:
  {Dispose both bitarrays}
  {Free will be allowed, even if object is not created, see remark above!!!}
  bitarray1.free;
  bitarray2.free;
  writeln('Free RAM after destroying bitarrays: ',memavail);
end;

begin {Main program is only one procedure}
  BitFieldDemo;
end.
