unit Cellimag;

(*********************************************
TCellImage -> TImage

An extension of TImage that supports segmenting the
image into a cell matrix.  Currently only one row of
horizontal cells is supported.

PROPERTIES:

Cells: Number of cells in the bitmap.

METHODS:

ImageCell: Return the specified cell as a TBitmap.
*********************************************)
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type

  TCellImage = class( TImage )
  private
     FCells: integer;
     bmTemp: TBitmap;
  protected
     procedure SetCells( const nArg: integer );
  public
     constructor Create( AOwner: TComponent ); override;
     destructor Destroy; override;
     function ImageCell( const nArg: integer ): TBitmap;     
  published
     property Cells: integer read FCells write SetCells;
  end;

procedure Register;

implementation

constructor TCellImage.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  bmTemp := TBitmap.Create;
end;

destructor TCellImage.Destroy;
begin
  bmTemp.Free;
  inherited Destroy;
end;

procedure TCellImage.SetCells( const nArg: integer );
begin
  if FCells <> nArg then
     FCells := nArg;
end;

(*********************************************
Return the frame in the specified index.
*********************************************)
function TCellImage.ImageCell( const nArg: integer ): TBitmap;
var
  rectSource, rectDest: TRect;
begin
  bmTemp.Width := Picture.Bitmap.Width div FCells;
  bmTemp.Height := Picture.Bitmap.Height;
  rectDest := Rect( 0, 0, bmTemp.Width, bmTemp.Height );
  rectSource.Left := ( nArg - 1 ) * ( Picture.Bitmap.Width div FCells );
  rectSource.Top := 0;
  rectSource.Right := rectSource.Left + ( Picture.Bitmap.Width div FCells );
  rectSource.Bottom := Picture.Bitmap.Height;
  bmTemp.Canvas.CopyRect( rectDest, Picture.Bitmap.Canvas, rectSource );
  Result := bmTemp;
end;

procedure Register;
begin
  RegisterComponents( 'SilCmd', [TCellImage] );
end;

end.
