unit Colrcal;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, Calendar;

type
  TColorGrid = Array [0..6,1..6] of TColor;
     {Array that holds the assigned color for each square on the calendar}

  TColorCalendar = class(TCalendar)
  private
     ColorGrid : TColorGrid;
  protected
     procedure DrawCell(ACol, ARow: Longint;
                       ARect: TRect;
                       AState: TGridDrawState); override;
  public
    constructor Create(AOwner: TComponent); override;
    Procedure SetDateColor(Adate: TDateTime;
                           Color : TColor);
    Procedure ResetColors;
  published
    { Published declarations }
  end;


procedure Register;

implementation
type
  EDateRangeError = class(Exception);
      {Exception that is raised if the date passed to SetDateColor is }
      {Not within the dates displayed by this calendar}


procedure Register;
begin
  RegisterComponents('Reno''s', [TColorCalendar]);
end;

Procedure TColorCalendar.ResetColors;
{This procedure put's 0's in the entire Color Grid Array}
{then it calls the parents Update Calendar Procedure}
{The UpdateCalendar Procedure does some other work then}
{It calls DrawCell for each cell in the calendar}
var Row,Col : integer;
Begin
  for Col := 0 to 6 do
   for Row := 1 to 6 do
       ColorGrid[Col,Row] := 0;
  UpdateCalendar;
End;

constructor TColorCalendar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Options := Options - [goDrawFocusSelected];
  {Turning of the goDrawFocusSelectd Option causes the calendar}
  {not to hilight the selected day}

   ResetColors;
end;


procedure TColorCalendar.DrawCell(ACol, ARow: Longint;
                                    ARect: TRect;
                                    AState: TGridDrawState);
var
  TheText: string;
  {Used by the CellText procedure to get the text from the grid}
  {that is pointed to by ACol and ARow}

begin
  TheText := CellText[ACol, ARow];
  {Get the date text from the current cell}
  If ARow > 0 then
    {We can skip row 0 because it holds the names of the days of the week}
    If TheText <> '' then
       {Can only set the color on grid cells that contain a date}
       Begin
       If gdSelected in AState then
           {the current box is selected, overwrite the selected box hilight}
           begin
           Canvas.Brush.Color := Color;
           Canvas.FillRect(ARect);
           end;
       If ColorGrid[ACol,ARow] > 0 then
           {Only try to set color on those cells that have been set}
           {by SetDateColor}
           begin
           Canvas.Brush.Color := ColorGrid[ACol,ARow];
           Canvas.FillRect(ARect);
           end
       end;
  Canvas.Font.Color := clBlack;
  with ARect, Canvas do
      TextRect(ARect, Left + (Right - Left - TextWidth(TheText)) div 2,
        Top + (Bottom - Top - TextHeight(TheText)) div 2, TheText);
        {This procedure was copied from the parent class}
end;

Procedure TColorCalendar.SetDateColor(Adate:TDateTime;
                                   Color : TColor);

var
Col,Row : Integer;
found : Boolean;
TheText, DayText : String;
AYear,AMonth,ADay : Word;

Begin
DecodeDate(Adate,AYear,AMonth,ADay);
{Turn the date into month,day, and year integers}
If AYear <> Year then
   raise EDateRangeError.Create
            ('The supplied date is not covered by this calendar');
   {If the year passed is different from the current year of the}
   {calendar, the EDateRangeError is raised.  You must check for this}
   {Exception in the calling code}
If AMonth <> Month then
   raise EDateRangeError.Create
        ('The supplied date is not covered by this calendar');
   {If the Month passed is different from the current month of the}
   {calendar, the EDateRangeError is raised.  You must check for this}
   {Exception in the calling code}

DayText := IntToStr(ADay);
  {search for the cell that contains the same day as the day passed}
  { to this procedure}
Found := False;
Row := 1;
   {again, we don't have to search the first row because the names}
   {of the days are there}

While not(Found) and (Row < 7) do
   {Found is a boolean variable that is set to true when the correct day}
   {has been found. This improves loop performance by allowing for }
   {early exit from the loop}
   begin
   Col := 0;
   While not(Found) and (Col < 7) do
       begin
       TheText := CellText[Col,Row];
       If TheText = dayText then
           begin
           Found := True;
           ColorGrid[Col,Row] := Color;
               {write the color of this cell to the color grid array}
           end;
       inc(Col);
       end;
   inc(Row);
   end;
end;
end.
