unit EdiProp;

interface

{$N+,S-,W-}

uses SysUtils, Classes, Graphics, Controls, Forms, TypInfo, Dsgnintf, Dialogs;

type

{ TReportFileProperty
  Property editor for the TCrystalReport.  Displays a File Open Dialog
  for the name of the report file.}

  TReportFileProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

implementation

{ TReportFileProperty }

procedure TReportFileProperty.Edit;
var
  ReportFileOpen: TOpenDialog;
begin
  ReportFileOpen := TOpenDialog.Create(Application);
  ReportFileOpen.Filename := GetValue;
  ReportFileOpen.Filter := 'Crystal Report files (*.RPT)|*.RPT|All files (*.*)|*.*';{LoadStr(SMPOpenFilter);}
{  MPFileOpen.HelpContext := hcDMediaPlayerOpen;}
  ReportFileOpen.Options := ReportFileOpen.Options + [ofShowHelp, ofPathMustExist,
    ofFileMustExist];
  try
    if ReportFileOpen.Execute then SetValue(ReportFileOpen.Filename);
  finally
    ReportFileOpen.Free;
  end;
end;

function TReportFileProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

end.
