unit Informes;

interface

uses
  Crpe, Dsgnintf,
  SysUtils, WinTypes, WinProcs, Messages, Classes, TypInfo, Ediprop;

type
  ECrystalError=Class(Exception);

  TCrystalReport = class(TComponent)
  private
    { Private declarations }
    FToPrinter: Boolean;
    FReportFile, FCaptionWindow: string;
  public
    { Public declarations }
    Constructor Create(AOwner:TComponent); override;
    Function Print: Integer;
    Destructor Free;
  published
    property ToPrinter: boolean read FToPrinter write FToPrinter;
    property ReportFile: string read FReportFile write FReportFile;
    property CaptionWindow: string read FCaptionWindow write FCaptionWindow;
  end;

Procedure Register;

implementation

Constructor TCrystalReport.Create(AOwner:TComponent);
begin
  Inherited Create(AOwner);
  if not PEOpenEngine then
     raise ECrystalError.Create('Unable to open Crystal Engine');
end;

Destructor TCrystalReport.Free;
begin
  PECloseEngine;
  Inherited Free;
end;

Function TCrystalReport.Print: Integer;
Var St,St2:Array[0..255] of char;
begin
  Result:= PEPrintReport(StrPCopy(St,FReportFile),
                FToPrinter,
                not FToPrinter,
                StrPCopy(St2,FCaptionWindow),
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                WS_VISIBLE or WS_SYSMENU or WS_BORDER or WS_MAXIMIZEBOX or
                WS_MINIMIZEBOX or WS_CAPTION or WS_SIZEBOX,
                0);
end;

Procedure Register;
begin
  RegisterComponents('Data Access',[TCrystalReport]);
  RegisterPropertyEditor(TypeInfo(string), TCrystalReport, 'ReportFile', TReportFileProperty);
end;

end.
