unit Boxes;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons,
  RHLstHdr, RHTabBox, RHLBoxCk, RHCtrl3d, Spin;

type
  TfrmBoxes = class(TForm)
    TabListBox1: TrhTabListBox;
    CheckListBox1: TrhCheckListBox;
    TabComboBox1: TrhTabComboBox;
    ListHeader1: TrhTabListHeader;
    Label3D2: TrhLabel3D;
    Label3D3: TrhLabel3D;
    Label3D1: TrhLabel3D;
    BitBtn1: TBitBtn;
    Bevel1: TBevel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Bevel2: TBevel;
    CheckBox4: TCheckBox;
    Bevel3: TBevel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton0: TRadioButton;
    SpinEdit1: TSpinEdit;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure TabListBox1Click(Sender: TObject);
    procedure CheckListBox1Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmBoxes: TfrmBoxes;

implementation

{$R *.DFM}

procedure TfrmBoxes.Button1Click(Sender: TObject);
begin
  TabListBox1.Items.Add(Edit1.Text + #9 + Edit2.Text + #9 + Edit3.Text);
end;

procedure TfrmBoxes.CheckBox3Click(Sender: TObject);
begin
  with Sender as TCheckBox do
    TabListBox1.ColumnVisible[Tag] := Checked;
end;

procedure TfrmBoxes.Button2Click(Sender: TObject);
begin
  TabListBox1.Items.Delete(TabListBox1.ItemIndex);
end;

procedure TfrmBoxes.TabListBox1Click(Sender: TObject);
begin
  Edit1.Text := TabListBox1.ColText[0];
  Edit2.Text := TabListBox1.ColText[1];
  Edit3.Text := TabListBox1.ColText[2];
end;

procedure TfrmBoxes.CheckListBox1Click(Sender: TObject);
begin
  CheckBox4.Caption := CheckListBox1.Items[CheckListBox1.ItemIndex];
  CheckBox4.Checked := CheckListBox1.Selected[CheckListBox1.ItemIndex];
end;

procedure TfrmBoxes.CheckBox4Click(Sender: TObject);
begin
  CheckListBox1.Selected[CheckListBox1.ItemIndex] := CheckBox4.Checked;
end;

procedure TfrmBoxes.RadioButton1Click(Sender: TObject);
begin
  with Sender as TRadioButton do begin
    if Checked then
      TabComboBox1.ColWidthCalc := TWidthCalc(Tag);
  end;
end;

procedure TfrmBoxes.FormCreate(Sender: TObject);
begin
  CheckBox1.Checked := TabListBox1.ColumnVisible[CheckBox1.Tag];
  CheckBox2.Checked := TabListBox1.ColumnVisible[CheckBox2.Tag];
  CheckBox3.Checked := TabListBox1.ColumnVisible[CheckBox3.Tag];

  Case TabComboBox1.ColWidthCalc of
    wcPixels      : RadioButton0.Checked := True;
    wcAverageChar : RadioButton1.Checked := True;
    wcMaxChar     : RadioButton2.Checked := True;
  end;

  SpinEdit1.Value := TabComboBox1.ColumnWidth[0];
end;

procedure TfrmBoxes.SpinEdit1Change(Sender: TObject);
begin
  TabComboBox1.ColumnWidth[0] := SpinEdit1.Value;
  TabComboBox1.ColumnWidth[1] := SpinEdit1.Value;
end;

end.
