{$X+}
{
                 DBBASE III+ Support component by Daniel Parnell

  I wrote the following code over a couple of hours because I noticed that
people were complaining in comp.lang.pascal (usenet newsgroup) that to use
any data base files in their applications made their resulting programs huge.
So, I grabbed my Delphi books and had a go at creating a DBASE III+ unit, and
here is the result.

  Now for the legal stuff.  Anybody can use the following code for anything
that they want.  I would however like to be notified of any use this code is
put to because I'm interested in seeing what is done with it.  Credit would
be nice also.

Note: These routines ignore the record deletion flag.

                                Daniel
                     s921878@minyos.xx.rmit.edu.au
}
unit DBase3P;

interface

uses Classes;

const
  MaxSize = $7FFF; { Size of the record buffer }
  maxFields = 16;  { Maximum number of fields }

type
  TBigArray = array[0..MaxSize] of char;
  PBigArray = ^TBigArray;

  THeader = record
    version        : byte;    { Should be 3 or $83 }
    year,month,day : byte;    { Date of last update }
    numRecs        : longint; { Number of records in the file }
    headLen        : word;    { Length of the header }
    recLen         : word;    { Length of individual records }
    rez            : array[0..19] of byte; { reserved }
  end;

  TField = record
    name   : array[0..10] of char;  { Name of the field }
    what   : char;                  { Type of data in this field }
    data   : array[0..1] of word;   { Not used }
    len    : byte;                  { Length of the field }
    places : byte;                  { Number of decimal places }
    rez    : array[0..13] of byte;  { Reserved data area }
  end;

  TDBase3Plus = class(TComponent)
  private
    FfileName : string;    { Name of the DB file }
    fileOpen  : boolean;   { TRUE if the file is open }
    DBfile    : file;      { The actual file }
    buffer    : PBigArray; { Temp buffer for record }

    procedure SetFileName(name : string);
  protected
  public
    cRecord   : longint;   { Current record }
    about     : THeader;         { Info about the file }
    numFields : byte;            { Number of fields in the file }
    fields    : array[1..maxFields] of TField;  { The field data }
    rec       : array[1..maxFields] of string; { Record data }

   constructor Create(AOWner : TComponent); override;
    destructor Destroy; override;

    procedure Close; virtual;
    procedure Open; virtual;
    procedure write(r : longint); virtual;
    procedure Seek(r : longint); virtual;
    procedure NewRecord; virtual;
    procedure GotoStart;
    procedure GotoEnd;
    procedure GotoNext;
  published
    property FileName : string read FfileName write SetFileName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('DBASE', [TDBase3Plus]);
end;

constructor TDBase3Plus.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  fileOpen:=FALSE;
  fileName:='';
  buffer:=nil;
end;

destructor TDBase3Plus.destroy;
begin
  if FileOpen then
    close;

  inherited destroy;
end;

procedure TDBase3Plus.SetFileName(name : string);
begin
{  if fileOpen then
    close; }

  FfileName:=name;
end;

procedure TDBase3Plus.open;
var
  i    : integer;
  temp : TField;
  done : boolean;

begin
  if FileOpen then
    close; { Close the file if it already open }

  done:=FALSE;

  system.assign(DBfile,FfileName);
  reset(DBfile,1);
  FileOpen:=TRUE;
  blockRead(DBFile,about,sizeof(THeader)); { Get the header }

  getMem(buffer,about.recLen); { Get some memory for the buffer }

  i:=1;
  repeat
    blockRead(DBFile,temp,sizeof(TField));
    if temp.name[0]<>#$0D then
      begin
        fields[i]:=temp;
        inc(i);
      end
    else
      done:=TRUE;
  until DONE;

  numFields:=i-1;
  seek(0);
end;

procedure TDBase3Plus.close;
begin
  system.close(DBfile);
  FileOpen:=FALSE;
  freeMem(buffer,about.recLen);
end;

procedure TDBase3Plus.write(r : longint);
var
  ad  : word;
  i,j : integer;
  s   : string;

begin
  cRecord:=r;
  system.seek(DBFile,r*about.recLen+about.headLen);

  buffer^[0]:=' '; { Record not deleted! }
  ad:=1;  { Skip over the deletion flag }
  for i:=1 to numFields do
    begin
      s:=rec[i];

      while length(s)<fields[i].len do
        s:=s+' ';

      for j:=1 to length(s) do
        begin
          buffer^[ad]:=s[j];
          inc(ad);
        end;
    end;

  blockWrite(DBFile,buffer^,about.recLen);
end;

procedure TDBase3Plus.seek(r : longint);
var
  ad  : word;
  i,j : integer;
  s   : string;

begin
  cRecord:=r;
  system.seek(DBFile,r*about.recLen+about.headLen);
  blockRead(DBFile,buffer^,about.recLen);

  ad:=1; { Ignore the deletion flag }
  for i:=1 to numFields do
    begin
      s:='';
      for j:=1 to fields[i].len do
        begin
          s:=s+buffer^[ad];
          inc(ad);
        end;

      while s[length(s)]=' ' do
        s:=copy(s,1,length(s)-1);
      rec[i]:=s;
    end;
end;

procedure TDBase3Plus.GotoStart;
begin
  seek(0);
end;

procedure TDBase3Plus.GotoEnd;
begin
  seek(about.numRecs-1);
end;

procedure TDBase3Plus.GotoNext;
begin
  seek(cRecord+1);
end;

procedure TDBase3Plus.NewRecord;
var
  i : integer;

begin
  for i:=1 to numFields do
    rec[i]:='';

  inc(about.numRecs);
  system.seek(DBFile,0);
  blockWrite(DBFile,about,sizeof(THeader));
  write(about.numRecs-1);
  seek(about.numRecs-1);
end;

end.
